/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.ManageDomainCertificateCommand;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import java.io.IOException;

@Parameters(commandDescription="Changes a certificate of an SSL host. The certificate must already be uploaded.")
public class ChangeDomainCertificateCommand
extends ManageDomainCertificateCommand {
    @Override
    public String getName() {
        return "change-domain-certificate";
    }

    @Override
    protected void callBackend(SslHostDTO sslHost) throws IOException {
        this.getRestClient().changeCertificate(this.host, this.account, this.sslHostName, sslHost);
    }

    @Override
    protected String getSuccessMessage(SslHostDTO sslHost) {
        return String.format("Certificate of SSL host '%s' changed to '%s'.", sslHost.getDisplayName(), this.certificate);
    }

    @Override
    protected String getCertificateNotFoundErrorMsg() {
        return "Cannot change certificate of SSL host '" + this.sslHostName + "' to '" + this.certificate + "' because the certificate does not exist; provide the name of an existing certificate";
    }

    @Override
    protected String getRequestNotSignedErrorMsg() {
        return "Cannot change certificate of SSL host '" + this.sslHostName + "' because '" + this.certificate + "' has a CSR that is not signed; you have to upload the signed certificate " + "for this CSR using the upload-domain-certificate command";
    }

    @Override
    protected String getGeneralErrorMsg() {
        return "Cannot change certificate; ";
    }
}

