/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.client.CertificateManagerRestClient;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.ListSslHostsCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.NoFreeResourcesException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.QuotaExceededException;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.SslHost;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Creates an SSL host for configuration of custom domains")
public class CreateSslHostCommand
extends BaseConsoleCommand {
    private static final String DEFAULT_NAME = "default";
    @Parameter(names={"-n", "--name"}, description="Unique identifier of the ssl host. The value must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9' \"_\" and \"-\". If not specified, 'default' value is set.")
    private String name;
    @Parameter(names={"-f", "--force"}, description="Force")
    private boolean force;

    @Override
    public String getName() {
        return "create-ssl-host";
    }

    @Override
    public void run() throws CommandException {
        this.checkParametersAndSetDefaultValues();
        this.dumpParameters();
        SslHostDTO sslHost = new SslHostDTO();
        sslHost.setAccountName(this.account);
        sslHost.setUsername(this.user);
        sslHost.setDisplayName(this.name);
        try {
            CertificateManagerRestClient client = this.getRestClient();
            client.createSslHost(this.host, this.account, sslHost, this.force);
            SslHost sslHostCreated = client.getSslHost(this.host, this.account, this.name);
            if (sslHostCreated != null) {
                System.out.println(String.format("A new SSL host '%s' was created and is now accessible on '%s'", sslHostCreated.getDisplayName(), sslHostCreated.getVirtualServerHostName()));
            }
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(e.getMessage(), 211);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new CommandException("SSL host with name '" + this.name + "' already exists; specify another name", 211);
        }
        catch (NoFreeResourcesException e) {
            throw new CommandException("No free resources to serve the request, contact SAP support", 211);
        }
        catch (QuotaExceededException e) {
            throw new CommandException(e.getMessage(), 212);
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException("Subaccount '" + this.account + "' does not have any global quotas defined", 213);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot create SSL host; make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParametersAndSetDefaultValues() {
        if (this.name == null || this.name.isEmpty()) {
            this.name = DEFAULT_NAME;
            System.out.println("You have not specified SSL host name. 'default' will be used");
        }
        Object[] nameDetails = new Object[]{"--name", this.name, 30};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacterWithoutDot(nameDetails);
    }

    private void printDomain(SslHost sslHost) {
        int nameMaxLen = "Name".length();
        int virtualServerMaxLen = "Virtual Server".length();
        int certificateMaxLen = "Certificate".length();
        String certName = "";
        if (sslHost.getCert() != null) {
            certName = sslHost.getCert().getName();
        }
        if (sslHost.getDisplayName().length() > nameMaxLen) {
            nameMaxLen = sslHost.getDisplayName().length();
        }
        if (sslHost.getVirtualServerHostName().length() > virtualServerMaxLen) {
            virtualServerMaxLen = sslHost.getVirtualServerHostName().length();
        }
        if (certName.length() > certificateMaxLen) {
            certificateMaxLen = certName.length();
        }
        String leftAlignFormat = "| %-" + nameMaxLen + "s | %-" + virtualServerMaxLen + "s | %-" + certificateMaxLen + "s |%n";
        ListSslHostsCommand.printHeader(leftAlignFormat, nameMaxLen, virtualServerMaxLen, certificateMaxLen);
        ListSslHostsCommand.printTableRow(leftAlignFormat, sslHost.getDisplayName(), sslHost.getVirtualServerHostName(), certName);
        ListSslHostsCommand.printFooter(nameMaxLen, virtualServerMaxLen, certificateMaxLen);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "name", this.name);
        DumpHelper.dumpOperationList(this.user, "Create a SSL host", argsList.toArray());
    }
}

