/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Returns the certificate signing request of the given certificate.")
public class DisplayCSRCommand
extends BaseConsoleCommand {
    @Parameter(names={"-n", "--name"}, description="Name of the certificate that you set to the ssl host; must be already uploaded.")
    private String name;
    @Parameter(names={"-f", "--file-name"}, description="Name of local file where to store the CSR")
    private String fileName;

    @Override
    public String getName() {
        return "display-csr";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        String csr = null;
        try {
            csr = this.getRestClient().downloadCSR(this.host, this.account, this.name);
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException("Certificate '" + this.name + "' does not exist; specify an existing certificate name", 211);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot display CSR; make sure the parameters are correct and try again.", 166);
        }
        this.printCSR(csr);
        if (this.fileName != null) {
            try {
                this.getFileIO(this.fileName).writeFileContent(csr);
            }
            catch (IOException e) {
                throw new HelpException("Problem writing " + this.fileName + "!");
            }
        }
    }

    private void printCSR(String csr) {
        System.out.println("Certificate signing request:");
        System.out.println();
        System.out.println(csr);
    }

    private void checkParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(new Object[]{"--name", this.name, 240});
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new ParameterException("File name should be a non-empty string!");
        }
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "name", this.name);
        if (this.fileName != null && this.fileName.length() != 0) {
            Collections.addAll(argsList, "file-name", this.fileName);
        }
        DumpHelper.dumpOperationList(this.user, "List certificates", argsList.toArray());
    }
}

