/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.InvalidDNException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.QuotaExceededException;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.CertificateInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Generates and returns a certificate signing request")
public class GenerateCsrCommand
extends BaseConsoleCommand {
    @Parameter(names={"-n", "--name"}, description="Unique identifier of the certificate. It can contain alphanumerics, '-' and '_'.")
    private String name;
    @Parameter(names={"-d", "--certificate-distinguished-name"}, description="Attributes of the CSR; formatted as type0=value0,type1=value1,type2=..., characters may be escaped by \\ (backslash), no spaces are skipped.\n \t\tAllowed attributes:\n\t\t\t    C=  Country  GB \n\t\t\t    ST=  State  London \n\t\t\t    L=  Location  London \n\t\t\t    O=  Organization  Global Security \n\t\t\t    OU=  Organizational Unit  IT Department \n\t\t\t    CN=  Common Name  example.com")
    private String dn;
    @Parameter(names={"-s", "--subject-alternative-name"}, description="Subject Alternative Names - comma separated host names of alternative base domains for this certificate")
    private String altName;
    @Parameter(names={"-k", "--key-size"}, description="The size/length of generated keypair. If not provided, the default length of 2048 is used.")
    private String keysize;
    @Parameter(names={"-g", "--signature-algorithm"}, description="If not provided, the default algorithm is used: SHA256withRSA")
    private String algorithm;
    @Parameter(names={"-f", "--force"}, description="Force")
    private boolean force = false;

    @Override
    public String getName() {
        return "generate-csr";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        CertificateInfo certificateInfo = new CertificateInfo();
        certificateInfo.setName(this.name);
        certificateInfo.setDistinguishedName(this.dn);
        certificateInfo.setAlternativeDomainNames(this.altName);
        try {
            String csr = this.getRestClient().generateCSR(this.host, this.account, certificateInfo, this.keysize, this.algorithm, this.force);
            System.out.println("Certificate signing request generated. Copy and paste the text below to your certificate authority.");
            System.out.println(csr);
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceAlreadyExistsException e) {
            throw new CommandException("Certificate '" + this.name + "' already exists; specify another name", 211);
        }
        catch (QuotaExceededException e) {
            throw new CommandException("Cannot create certificates because you have reached your quota limit. Please delete unused certificates and try again.", 212);
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException("Subaccount '" + this.account + "' does not have any global quotas defined", 213);
        }
        catch (InvalidDNException e) {
            throw new HelpException("Wrong value of parameter -d; specify valid distinguished names.For example:\n-d C=Bulgaria,O=MyCompany,CN=www.mycompany.bg\"", 167);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, e.getMessage(), 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot generate CSR; make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacterWithoutDot(new Object[]{"--name", this.name, 240});
        validator.validateDistinguishName(new String[]{"--certificate-distinguished-name", this.dn});
        validator.validateKeysizeParameter(this.keysize);
        validator.validateSignatureAlgorithmParameter(this.algorithm);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "certificate-distinguished-name", this.dn, "name", this.name, "subject-alternative-name", this.altName, "keysize", this.keysize, "signature-algorithm", this.algorithm, "force", this.force);
        DumpHelper.dumpOperationList(this.user, "Generate CSR", argsList.toArray());
    }
}

