/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.PlatformDomainException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists all domain names on which an application can be accessed")
public class ListApplicationDomainsCommand
extends BaseConsoleCommand {
    @Parameter(names={"-b", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    private String application;
    @Parameter(names={"-c", "--component"}, description="Component", hidden=true)
    private String component = "web";
    @Parameter(names={"-o", "--all"}, description="Show both custom and platform domains (in any)", hidden=true)
    private boolean all = false;

    @Override
    public String getName() {
        return "list-application-domains";
    }

    @Override
    public String getGroup() {
        return "application-domains";
    }

    @Override
    public void run() throws CommandException {
        this.checkRequiredParameters();
        this.dumpParameters();
        try {
            List<String> platformDomains;
            StringBuilder list = new StringBuilder();
            try {
                List<String> customDomains = this.getRestClient().listCustommDomains(this.host, this.account, this.application, this.component);
                if (customDomains != null && !customDomains.isEmpty()) {
                    for (String domain : customDomains) {
                        list.append("\n\t" + domain);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error listing Custom Domains - will ignore it", e);
            }
            if ((list.length() == 0 || this.all) && (platformDomains = this.getRestClient().listPlatformDomains(this.host, this.account, this.application, this.component)) != null && !platformDomains.isEmpty()) {
                for (String domain : platformDomains) {
                    list.append("\n\t" + domain);
                }
            }
            System.out.println(String.format("Application domains: %s", list.toString()));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException("Application not found; make sure --application parameter is correct", 211);
        }
        catch (PlatformDomainException e) {
            throw new CommandException(e.getMessage(), 210);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("Error:", e);
            throw new HelpException("Cannot list platform domains; make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkRequiredParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateLength("--application", this.application, 30);
        if (this.component == null || this.component.isEmpty()) {
            this.component = "web";
        }
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "application", this.application);
        DumpHelper.dumpOperationList(this.user, "List platform domains of application", argsList.toArray());
    }
}

