/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.CustomDomainUrls;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists custom domains configured as access points for applications in a subaccount")
public class ListCustomDomainMappingsCommand
extends BaseConsoleCommand {
    @Override
    public String getName() {
        return "list-custom-domain-mappings";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        List<Object> mappings = Collections.emptyList();
        try {
            mappings = this.getRestClient().getAllCustomDomainURLs(this.host, this.account);
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot list mappings; make sure the parameters are correct and try again.", 166);
        }
        if (mappings == null | mappings.isEmpty()) {
            System.out.println("There are no mappings defined for subaccount '" + this.account + "'");
            return;
        }
        this.printOutput(mappings);
    }

    private void printOutput(Collection<CustomDomainUrls> customDomainUrls) {
        for (CustomDomainUrls urls : customDomainUrls) {
            System.out.println("---------------------------------------------------------------------");
            System.out.println(urls.getCustomUrl() + " <> " + urls.getPlatformUrl());
            System.out.println("SSL host : " + urls.getSslHost().getDisplayName());
            System.out.println("Certificate : " + (urls.getSslHost().getCert() == null ? "" : urls.getSslHost().getCert().getName()));
        }
        System.out.println("---------------------------------------------------------------------");
    }

    private void printOutputTable(Collection<CustomDomainUrls> mappings) {
        int customUrlMaxLen = 30;
        int platformUrlMaxLen = 30;
        int sshlHostMaxLen = 25;
        for (CustomDomainUrls mapping : mappings) {
            String sslHostName;
            String platformUrl;
            String customUrl = mapping.getCustomUrl();
            if (customUrl.length() > customUrlMaxLen) {
                customUrlMaxLen = customUrl.length();
            }
            if ((platformUrl = mapping.getPlatformUrl()).length() > platformUrlMaxLen) {
                platformUrlMaxLen = platformUrl.length();
            }
            if (mapping.getSslHost() == null || (sslHostName = mapping.getSslHost().getDisplayName()).length() <= sshlHostMaxLen) continue;
            sshlHostMaxLen = sslHostName.length();
        }
        String leftAlignFormat = "| %-" + sshlHostMaxLen + "s | %-" + customUrlMaxLen + "s | %-" + platformUrlMaxLen + "s |%n";
        this.printHeader(leftAlignFormat, sshlHostMaxLen, customUrlMaxLen, platformUrlMaxLen);
        this.printTableContent(mappings, leftAlignFormat);
        this.printFooter(sshlHostMaxLen, customUrlMaxLen, platformUrlMaxLen);
    }

    private void printTableContent(Collection<CustomDomainUrls> mappings, String leftAlignFormat) {
        for (CustomDomainUrls mapping : mappings) {
            String sslHostName = "";
            if (mapping.getSslHost() != null) {
                sslHostName = mapping.getSslHost().getDisplayName();
            }
            String customUrl = "";
            if (mapping.getCustomUrl() != null) {
                customUrl = mapping.getCustomUrl();
            }
            String platformUrl = "";
            if (mapping.getPlatformUrl() != null) {
                platformUrl = mapping.getPlatformUrl();
            }
            System.out.format(leftAlignFormat, sslHostName, customUrl, platformUrl);
        }
    }

    private void printFooter(int sshlHostMaxLen, int customUrlMaxLen, int platformUrlMaxLen) {
        System.out.format("+-" + this.padString("-", sshlHostMaxLen) + "-+-" + this.padString("-", customUrlMaxLen) + "-+-" + this.padString("-", platformUrlMaxLen) + "-+%n", new Object[0]);
    }

    private void printHeader(String leftAlignFormat, int sshlHostMaxLen, int customUrlMaxLen, int platformUrlMaxLen) {
        System.out.format("+-" + this.padString("-", sshlHostMaxLen) + "-+-" + this.padString("-", customUrlMaxLen) + "-+-" + this.padString("-", platformUrlMaxLen) + "-+%n", new Object[0]);
        System.out.format(leftAlignFormat, "Ssl Host Display Name", "Custom URL", "Platform URL");
        System.out.format("+-" + this.padString("-", sshlHostMaxLen) + "-+-" + this.padString("-", customUrlMaxLen) + "-+-" + this.padString("-", platformUrlMaxLen) + "-+%n", new Object[0]);
    }

    private String padString(String string, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    private void checkParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account);
        DumpHelper.dumpOperationList(this.user, "Lists custom domains configured as access points for applications in a subaccount.", argsList.toArray());
    }
}

