/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.Certificate;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Parameters(commandDescription="Lists custom domain certificates")
public class ListDomainCertificatesCommand
extends BaseConsoleCommand {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");

    @Override
    public String getName() {
        return "list-domain-certificates";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        Collection<Object> certificates = Collections.emptyList();
        try {
            certificates = this.getRestClient().listCertificates(this.host, this.account);
            try {
                int remainingQuota = this.getRestClient().getRemainingCertificatesQuota(this.host, this.account);
                int quota = remainingQuota + certificates.size();
                System.out.println(String.format("Certificates for subaccount '%s': %s. Account quota: %s", this.account, certificates.size(), quota));
            }
            catch (Exception e) {}
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot list certificates; make sure the parameters are correct and try again.", 166);
        }
        if (certificates == null | certificates.isEmpty()) {
            System.out.println("There are no certificates created for subaccount '" + this.account + "'");
            return;
        }
        this.printOutput(certificates);
    }

    private void printOutput(Collection<Certificate> certificates) {
        for (Certificate cert : certificates) {
            try {
                String commaSeparatedDomains = cert.getDomainNames() == null ? "" : cert.getDomainNames();
                String[] domainNames = commaSeparatedDomains.split(",");
                String expDate = "";
                if (cert.getExpirationDate() != null) {
                    expDate = DATE_FORMAT.format(cert.getExpirationDate());
                }
                System.out.println("---------------------------------------------------------------------");
                System.out.println(cert.getName());
                System.out.println("CSR generated on SAP Cloud Platform: " + (cert.getCsr() == null ? "no" : "yes"));
                StringBuilder sb = new StringBuilder("Subject: CN=" + this.getFirstFomain(domainNames));
                for (int i = 1; i < domainNames.length; ++i) {
                    sb.append("," + domainNames[i]);
                }
                System.out.println(sb.toString());
                if (cert.getExpirationDate() != null) {
                    System.out.println("Validity: " + expDate);
                    continue;
                }
                System.out.println("Public certificate key not available.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("---------------------------------------------------------------------");
    }

    private void printOutputTable(Collection<Certificate> certificates) {
        int nameMaxLen = "Name".length();
        int domainNameMaxLen = "Domain Names".length();
        int expDateMaxLen = "Exp Date".length();
        int statusMaxLen = "Status".length();
        for (Certificate cert : certificates) {
            String commaSeparatedDomains = cert.getDomainNames() == null ? "" : cert.getDomainNames();
            String[] domainNames = commaSeparatedDomains.split(",");
            String firstDomain = this.getFirstFomain(domainNames);
            String expDate = "";
            if (cert.getExpirationDate() != null) {
                expDate = DATE_FORMAT.format(cert.getExpirationDate());
            }
            if (cert.getName().length() > nameMaxLen) {
                nameMaxLen = cert.getName().length();
            }
            if (firstDomain.length() > domainNameMaxLen) {
                domainNameMaxLen = firstDomain.length();
            }
            for (int i = 1; i < domainNames.length; ++i) {
                if (domainNames[i].length() <= domainNameMaxLen) continue;
                domainNameMaxLen = domainNames[i].length();
            }
            if (expDate.length() > expDateMaxLen) {
                expDateMaxLen = expDate.length();
            }
            if (this.getCSRStatus(expDate).toString().length() <= statusMaxLen) continue;
            statusMaxLen = this.getCSRStatus(expDate).toString().length();
        }
        String leftAlignFormat = "| %-" + nameMaxLen + "s | %-" + domainNameMaxLen + "s | " + "%-" + expDateMaxLen + "s | %-" + statusMaxLen + "s |%n";
        this.printHeader(leftAlignFormat, nameMaxLen, domainNameMaxLen, expDateMaxLen, statusMaxLen);
        this.printTableContent(certificates, leftAlignFormat);
        this.printFooter(nameMaxLen, domainNameMaxLen, expDateMaxLen, statusMaxLen);
    }

    private void printTableContent(Collection<Certificate> certificates, String leftAlignFormat) {
        for (Certificate cert : certificates) {
            try {
                String commaSeparatedDomains = cert.getDomainNames() == null ? "" : cert.getDomainNames();
                String[] domainNames = commaSeparatedDomains.split(",");
                String firstDomain = this.getFirstFomain(domainNames);
                String expDate = "";
                if (cert.getExpirationDate() != null) {
                    expDate = DATE_FORMAT.format(cert.getExpirationDate());
                }
                System.out.format(leftAlignFormat, cert.getName(), firstDomain, expDate, this.getCSRStatus(expDate));
                for (int i = 1; i < domainNames.length; ++i) {
                    System.out.format(leftAlignFormat, "", domainNames[i], "", "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object getCSRStatus(String expDate) {
        if (expDate == null || expDate.isEmpty()) {
            return "IN PROGRESS";
        }
        return "COMPLETED";
    }

    private String getFirstFomain(String[] domainNames) {
        if (domainNames.length > 0) {
            return domainNames[0];
        }
        return "";
    }

    private void printFooter(int nameMaxLen, int domainNameMaxLen, int expDateMaxLen, int statusMaxLen) {
        System.out.format("+-" + this.padString("-", nameMaxLen) + "-+-" + this.padString("-", domainNameMaxLen) + "-+-" + this.padString("-", expDateMaxLen) + "-+-" + this.padString("-", statusMaxLen) + "-+%n", new Object[0]);
    }

    private void printHeader(String leftAlignFormat, int nameMaxLen, int domainNamesMaxLen, int expDateMaxLen, int statusMaxLen) {
        System.out.format("+-" + this.padString("-", nameMaxLen) + "-+-" + this.padString("-", domainNamesMaxLen) + "-+-" + this.padString("-", expDateMaxLen) + "-+-" + this.padString("-", statusMaxLen) + "-+%n", new Object[0]);
        System.out.format(leftAlignFormat, "Name", "Domain Names", "Exp Date", "Status");
        System.out.format("+-" + this.padString("-", nameMaxLen) + "-+-" + this.padString("-", domainNamesMaxLen) + "-+-" + this.padString("-", expDateMaxLen) + "-+-" + this.padString("-", statusMaxLen) + "-+%n", new Object[0]);
    }

    private void checkParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account);
        DumpHelper.dumpOperationList(this.user, "List certificates", argsList.toArray());
    }

    private String padString(String string, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }
}

