/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.SslHost;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Parameters(commandDescription="Lists SSL hosts for a given subaccount")
public class ListSslHostsCommand
extends BaseConsoleCommand {
    @Parameter(names={"-t", "--supported-protocols "}, description="Shows the supported SSL protocols for SSL hosts", hidden=true)
    private boolean listSupportedProtocols;

    @Override
    public String getName() {
        return "list-ssl-hosts";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        Collection<Object> domains = Collections.emptyList();
        try {
            domains = this.getRestClient().listSSlHosts(this.host, this.account, this.listSupportedProtocols);
            int remainingQuota = this.getRestClient().getRemainingCustomDomainsQuota(this.host, this.account);
            int quota = remainingQuota + domains.size();
            System.out.println(String.format("SSL hosts for subaccount '%s': %s. Account quota: %s", this.account, domains.size(), quota));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException("Subaccount '" + this.account + "' does not have any global quotas defined", 213);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot list SSL host; make sure the parameters are correct and try again.", 166);
        }
        if (domains == null | domains.isEmpty()) {
            System.out.println("No SSL hosts found for subaccount'" + this.account + "'");
            return;
        }
        this.printOutput(domains);
    }

    private void printOutput(Collection<SslHost> sslHosts) {
        for (SslHost sslHost : sslHosts) {
            this.printSSLHostOutput(sslHost, this.listSupportedProtocols);
        }
        System.out.println("---------------------------------------------------------------------");
    }

    private void printOutputTable(Collection<SslHost> domains) {
        int nameMaxLen = "Name".length();
        int virtualServerMaxLen = "Host".length();
        int certificateMaxLen = "Certificate".length();
        for (SslHost host : domains) {
            String name = "";
            if (host.getCert() != null) {
                name = host.getCert().getName();
            }
            if (host.getDisplayName().length() > nameMaxLen) {
                nameMaxLen = host.getDisplayName().length();
            }
            if (host.getVirtualServerHostName().length() > virtualServerMaxLen) {
                virtualServerMaxLen = host.getVirtualServerHostName().length();
            }
            if (name.length() <= certificateMaxLen) continue;
            certificateMaxLen = name.length();
        }
        String leftAlignFormat = "| %-" + nameMaxLen + "s | %-" + virtualServerMaxLen + "s | %-" + certificateMaxLen + "s |%n";
        ListSslHostsCommand.printHeader(leftAlignFormat, nameMaxLen, virtualServerMaxLen, certificateMaxLen);
        ListSslHostsCommand.printTableContent(domains, leftAlignFormat);
        ListSslHostsCommand.printFooter(nameMaxLen, virtualServerMaxLen, certificateMaxLen);
    }

    protected static void printTableContent(Collection<SslHost> sslHosts, String leftAlignFormat) {
        for (SslHost host : sslHosts) {
            String name = "";
            if (host.getCert() != null) {
                name = host.getCert().getName();
            }
            ListSslHostsCommand.printTableRow(leftAlignFormat, host.getDisplayName(), host.getVirtualServerHostName(), name);
        }
    }

    protected static void printTableRow(String leftAlignFormat, String displayName, String virtServer, String certName) {
        System.out.format(leftAlignFormat, displayName, virtServer, certName);
    }

    protected static void printFooter(int nameMaxLen, int virtualServerMaxLen, int certificateMaxLen) {
        System.out.format("+-" + ListSslHostsCommand.padString("-", nameMaxLen) + "-+-" + ListSslHostsCommand.padString("-", virtualServerMaxLen) + "-+-" + ListSslHostsCommand.padString("-", certificateMaxLen) + "-+%n", new Object[0]);
    }

    protected static void printHeader(String leftAlignFormat, int nameMaxLen, int virtualServerMaxLen, int certificateMaxLen) {
        System.out.format("+-" + ListSslHostsCommand.padString("-", nameMaxLen) + "-+-" + ListSslHostsCommand.padString("-", virtualServerMaxLen) + "-+-" + ListSslHostsCommand.padString("-", certificateMaxLen) + "-+%n", new Object[0]);
        System.out.format(leftAlignFormat, "Name", "Host", "Certificate");
        System.out.format("+-" + ListSslHostsCommand.padString("-", nameMaxLen) + "-+-" + ListSslHostsCommand.padString("-", virtualServerMaxLen) + "-+-" + ListSslHostsCommand.padString("-", certificateMaxLen) + "-+%n", new Object[0]);
    }

    protected static String padString(String string, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    private void checkParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account);
        DumpHelper.dumpOperationList(this.user, "List SSL hosts for custom domains", argsList.toArray());
    }
}

