/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.CertificateNotBoundException;
import com.sap.core.certificate.manager.commons.exception.CertificateNotFoundException;
import com.sap.core.certificate.manager.commons.exception.RequestNotSignedException;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public abstract class ManageDomainCertificateCommand
extends BaseConsoleCommand {
    @Parameter(names={"-c", "--certificate"}, description="Name of the certificate that you set to the ssl host; must be already uploaded.")
    protected String certificate;
    @Parameter(names={"-l", "--ssl-host"}, description="SSL host name (as defined with --name parameter when created, or 'default' if not specified on create)")
    protected String sslHostName;

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        SslHostDTO sslHost = new SslHostDTO();
        sslHost.setAccountName(this.account);
        sslHost.setUsername(this.user);
        sslHost.setDisplayName(this.sslHostName);
        sslHost.setCertificateName(this.certificate);
        try {
            this.callBackend(sslHost);
            System.out.println(this.getSuccessMessage(sslHost));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(this.getSslHostNotFoundErrorMsg(this.sslHostName), 211);
        }
        catch (CertificateNotFoundException e) {
            throw new CommandException(this.getCertificateNotFoundErrorMsg(), 211);
        }
        catch (RequestNotSignedException e) {
            throw new CommandException(this.getRequestNotSignedErrorMsg(), 211);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new CommandException("Certificate already bound", 211);
        }
        catch (CertificateNotBoundException e) {
            throw new CommandException("Failed to change certificate. No certificate previously bound. Use bind-domain-certificate command to bind an existing certificate to ssl host.", 211);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException(this.getGeneralErrorMsg() + "make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParameters() {
        Object[] sslHostNameDetails = new Object[]{"--ssl-host", this.sslHostName, 240};
        Object[] certificateDetails = new Object[]{"--certificate", this.certificate, 255};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(sslHostNameDetails);
        validator.validateWithSpecialCharacter(certificateDetails);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "certificate", this.certificate, "ssl-host", this.sslHostName);
        DumpHelper.dumpOperationList(this.user, "Sets a certificate to an SSL host. The certificate must already be uploaded.", argsList.toArray());
    }

    protected abstract void callBackend(SslHostDTO var1) throws IOException;

    protected abstract String getSuccessMessage(SslHostDTO var1);

    protected abstract String getCertificateNotFoundErrorMsg();

    protected abstract String getRequestNotSignedErrorMsg();

    protected abstract String getGeneralErrorMsg();
}

