/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.AppUrlMappingException;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.CustomDomainUrlsDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

@Parameters(commandDescription="Removes a custom domain as an access point of an application")
public class RemoveCustomDomainCommand
extends BaseConsoleCommand {
    @Parameter(names={"-l", "--ssl-host"}, description="SSL host name (as defined with --name parameter when created, or 'default' if not specified on create)")
    private String sslHostName;
    @Parameter(names={"-e", "--custom-domain"}, description="Custom domain for accessing the application. Should be domain name like mydomain.com, shop.mydomain.com, etc.")
    private String customAppUrl;
    @Parameter(names={"-f", "--force"}, description="Force")
    private boolean force;

    @Override
    public String getName() {
        return "remove-custom-domain";
    }

    @Override
    public String getGroup() {
        return "application-domains";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        try {
            CustomDomainUrlsDTO urlMapping = new CustomDomainUrlsDTO();
            urlMapping.setCustomUrl(this.customAppUrl);
            urlMapping.setSslHostDisplayName(this.sslHostName);
            String removedAppUrl = this.getRestClient().removeApplicationURLMapping(this.host, this.account, this.sslHostName, urlMapping);
            System.out.println(String.format("Application with URL '%s' is not accessible anymore with custom domain '%s'", removedAppUrl, this.customAppUrl));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(this.getSslHostNotFoundErrorMsg(this.sslHostName), 211);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (AppUrlMappingException e) {
            LOGGER.error("Backend error:", e);
            throw new CommandException(e.getMessage(), 215);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot unmap custom domain;make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParameters() {
        Object[] sslHostNameDetails = new Object[]{"--ssl-host", this.sslHostName, 240};
        String[] customAppUrlDetails = new String[]{"--custom-domain", this.customAppUrl};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(sslHostNameDetails);
        try {
            validator.validateURL(new String[][]{customAppUrlDetails});
        }
        catch (ValidationException e) {
            if (e.getMessage().startsWith("Invalid parameter")) {
                System.out.println("Invalid value for --custom-domain parameter provided : " + this.customAppUrl + " , but the command will be processed further.");
            }
            throw e;
        }
        this.customAppUrl = this.customAppUrl.toLowerCase(Locale.ENGLISH);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "ssl-host", this.sslHostName, "custom-domain", this.customAppUrl);
        DumpHelper.dumpOperationList(this.user, "Remove custom domain as access point of application.", argsList.toArray());
    }
}

