/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.client.CertificateManagerRestClient;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.BadRequestException;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.ClientCertCfgModeEnum;
import com.sap.core.certificate.manager.commons.model.Constants;
import com.sap.core.certificate.manager.commons.model.SslHost;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import com.sap.core.certificate.manager.commons.validation.CustomDomainsValidationUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Parameters(commandDescription="Configures an SSL host")
public class SetSslHostCommand
extends BaseConsoleCommand {
    private static final String DEFAULT_NAME = "default";
    @Parameter(names={"-n", "--name"}, description="Name of the ssl host that will be configured.")
    private String name;
    @Parameter(names={"-c", "--certificate"}, description="(optional) Name of the domain certificate to bind to the ssl host; must be already uploaded. Replaces the previously bound certificate.")
    private String certificate;
    @Parameter(names={"-t", "--supported-protocols "}, description="(optional) Protocols to enable for the ssl host. Prerequisite: a domain certificate bound to the ssl host. Acceptable values: TLSV1_2, TLSV1_1, and TLSV1. Delimiter = comma (,)\n\t\t\t\tExample: --supported-protocols \"TLSV1_2,TLSV1_1\"\n\t\t\t\t         In this case, TLSV1 is disabled.")
    private String supportedProtocols;
    @Parameter(names={"--ca-bundle"}, description="Bundle of CA certificates and the mode for applying client cert authentication.\n\t\t\t\t\t Syntax [bundle]:[switch]. Acceptable switch values: [request|require|none]. Default:request.\n\t\t\t\t\t Example: --ca-bundle mybundle:require")
    private String caBundle;
    private String caBundleName;
    private ClientCertCfgModeEnum caBundleMode;

    @Override
    public String getName() {
        return "set-ssl-host";
    }

    @Override
    public void run() throws CommandException {
        this.checkParametersAndSetDefaultValues();
        this.dumpParameters();
        SslHostDTO sslHost = new SslHostDTO();
        sslHost.setAccountName(this.account);
        sslHost.setUsername(this.user);
        sslHost.setDisplayName(this.name);
        sslHost.setCertificateName(this.certificate);
        sslHost.setSupportedProtocols(this.supportedProtocols);
        if (this.caBundle != null) {
            sslHost.setClientCertBundleName(this.caBundleName);
            sslHost.setClientCertCfgMode(this.caBundleMode);
        }
        try {
            SslHost sslHostUpdated;
            CertificateManagerRestClient client = this.getRestClient();
            if (this.certificate != null || this.supportedProtocols != null || this.caBundle != null) {
                client.setSslHost(this.host, this.account, sslHost);
            }
            if ((sslHostUpdated = client.getSslHost(this.host, this.account, this.name, true)) != null) {
                this.printOutput(sslHostUpdated);
            }
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(this.getSslHostNotFoundErrorMsg(this.name), 211);
        }
        catch (BadRequestException e) {
            throw new CommandException(e.getMessage(), 400);
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException("Subaccount '" + this.account + "' does not have any global quotas defined", 213);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, e.getMessage(), 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot create SSL host; make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParametersAndSetDefaultValues() {
        if (this.name == null || this.name.isEmpty()) {
            this.name = DEFAULT_NAME;
            System.out.println("You have not specified SSL host name. 'default' will be used");
        }
        Object[] nameDetails = new Object[]{"--name", this.name, 30};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(nameDetails);
        if (this.certificate != null) {
            Object[] certificateDetails = new Object[]{"--certificate", this.certificate, 255};
            validator.validateWithSpecialCharacter(certificateDetails);
        }
        if (this.supportedProtocols != null) {
            String[] splitted;
            for (String protocol : splitted = this.supportedProtocols.split(",")) {
                if (CustomDomainsValidationUtil.isValidSupportedProtocol(protocol.trim())) continue;
                throw new ValidationException("Unknown value [" + protocol + "] for parameter \"" + "--supported-protocols " + "\". Acceptable values: " + Arrays.toString(Constants.SUPPORTED_PROTOCOLS), 166);
            }
        }
        if (this.caBundle != null) {
            if (!this.caBundle.contains(":")) {
                this.caBundleName = this.caBundle;
                this.caBundleMode = ClientCertCfgModeEnum.REQUEST;
            } else {
                int lastIndex;
                int firstIndex = this.caBundle.indexOf(":");
                if (firstIndex != (lastIndex = this.caBundle.lastIndexOf(":"))) {
                    throw new ValidationException("Wrong value '" + this.caBundle + "' for parameter " + "--ca-bundle" + ". " + "Specify CA bundle name, optionally followed by a colon (" + ":" + ") " + "and " + "[request|require|none]" + " to specify if client certificate is mandatory. Default: " + ClientCertCfgModeEnum.REQUEST.name().toLowerCase() + "\n" + "\t\t Example: " + "--ca-bundle" + " mybundle:" + ClientCertCfgModeEnum.REQUIRE.name().toLowerCase());
                }
                String[] splittedCABundle = this.caBundle.split(":");
                this.caBundleName = splittedCABundle[0];
                String caBundleModeName = splittedCABundle[1];
                try {
                    this.caBundleMode = ClientCertCfgModeEnum.getByName(caBundleModeName);
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException("Unknown switch value '" + caBundleModeName + "' for parameter \"" + "--ca-bundle" + "\". Acceptable values: " + "[request|require|none]");
                }
            }
        }
    }

    protected void printOutput(SslHost sslHost) {
        this.printSSLHostOutput(sslHost, true);
        System.out.println("---------------------------------------------------------------------");
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "name", this.name, "certificate", this.certificate, "supported protocols", this.supportedProtocols, "ca bundle", this.caBundle);
        DumpHelper.dumpOperationList(this.user, "Changes certificate and supported protocols to a SSL host", argsList.toArray());
    }
}

