/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.CertificateNotFoundException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.SslHost;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Unbinds a certificate from an SSL host. The certificate will not be deleted from SAP Cloud Platform storage")
public class UnbindDomainCertificateCommand
extends BaseConsoleCommand {
    @Parameter(names={"-l", "--ssl-host"}, description="SSL host name (as defined with --name parameter when created, or 'default' if not specified on create)")
    private String sslHostName;

    @Override
    public String getName() {
        return "unbind-domain-certificate";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        try {
            this.getRestClient().unbindCertificate(this.host, this.account, this.sslHostName);
            SslHost sslHost = this.getRestClient().getSslHost(this.host, this.account, this.sslHostName);
            System.out.println(String.format("Certificate '%s' removed from SSL host '%s'.", sslHost.getDisplayName(), sslHost.getVirtualServerHostName()));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (CertificateNotFoundException e) {
            throw new CommandException(e.getMessage(), 211);
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(this.getSslHostNotFoundErrorMsg(this.sslHostName), 211);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot unbind certificate; make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParameters() {
        Object[] sslHostNameDetails = new Object[]{"--ssl-host", this.sslHostName, 240};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(sslHostNameDetails);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "ssl-host-name", this.sslHostName);
        DumpHelper.dumpOperationList(this.user, "Unbinds a certificate from an SSL host. The certificate will not be deleted from SAP Cloud Platform storage.", argsList.toArray());
    }
}

