/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.client.FileIO;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.KeysDoNotMatchException;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.ResourceInUseException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.CertificateDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Uploads a signed custom domain certificate using either:\n\t- the previously generated CSR via the generate-csr command\n\t  or\n\t- the corresponding private key")
public class UploadDomainCertificateCommand
extends BaseConsoleCommand {
    @Parameter(names={"-n", "--name"}, description="Name of the certificate")
    private String name;
    @Parameter(names={"-l", "--location"}, description="File name containing certificate data")
    private String filePublicCert;
    @Parameter(names={"-k", "--key-location"}, description="(optional) File name containing private key")
    private String filePrivatekey;
    @Parameter(names={"-f", "--force"}, description="Replace existing")
    private boolean force;

    @Override
    public String getName() {
        return "upload-domain-certificate";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        CertificateDTO cert = new CertificateDTO();
        cert.setName(this.name);
        cert.setPublicKey(this.readFileContent("--location"));
        if (this.filePrivatekey != null) {
            this.showWarningAndAskForConfirmationToContinue();
            cert.setPrivateKey(this.readFileContent("--key-location"));
        }
        try {
            if (cert.getPrivateKey() != null) {
                try {
                    this.getRestClient().updateCertificate(this.host, this.account, this.name, cert, this.force);
                }
                catch (ResourceNotFoundException rnf) {
                    this.getRestClient().uploadCertificate(this.host, this.account, cert);
                }
            } else {
                this.getRestClient().uploadPublicKey(this.host, this.account, this.name, cert, this.force);
            }
            System.out.println(String.format("SSL certificate '%s' uploaded.", this.name));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(String.format("Certificate '%s' does not exist; use the name of the certificate previously used in the generate-csr command", this.name), 211);
        }
        catch (KeysDoNotMatchException e) {
            if (this.filePrivatekey != null) {
                if (e.getMessage() != null && e.getMessage().indexOf("Failed to import certificate") > -1) {
                    throw new CommandException("The provided private key and certificate do not match. Check again both files.", 211);
                }
                throw new CommandException(String.format("Certificate with name [%s] already exists and its private key does not match the provided one. Delete existing certificate or retry command with --force option", this.name), 211);
            }
            throw new CommandException("The provided public key does not match the stored private key. Please follow the documentation on how to generate CSR", 211);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new CommandException("Certificate '" + this.name + "' already exist; specify different certificate name", 215);
        }
        catch (ResourceInUseException e) {
            this.proccessCertManagerException(e, String.format("Certificate [%s] is in use. Unbind it, upload a new certificate and bind it again.", this.name), 215);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, e.getMessage(), 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot upload public key; make sure the parameters are correct and try again.", 166);
        }
    }

    private String readFileContent(String param) {
        FileIO fileIO = null;
        switch (param) {
            case "--location": {
                fileIO = this.getFileIO(this.filePublicCert);
                if (!fileIO.exists()) {
                    throw new HelpException(String.format("Invalid value of parameter %s . The file is not found. Specify the correct file containing %s in PEM format.", "--location", "certificate"), 211);
                }
                try {
                    return fileIO.readFileContent();
                }
                catch (IOException e) {
                    throw new HelpException(String.format("Invalid value of parameter %s . The file is invalid. Specify the correct file containing valid %s in PEM format.", "--location", "certificate"), 211);
                }
            }
            case "--key-location": {
                fileIO = this.getFileIO(this.filePrivatekey);
                if (!fileIO.exists()) {
                    throw new HelpException(String.format("Invalid value of parameter %s . The file is not found. Specify the correct file containing %s in PEM format.", "--key-location", "private key"), 211);
                }
                try {
                    return fileIO.readFileContent();
                }
                catch (IOException e) {
                    throw new HelpException(String.format("Invalid value of parameter %s . The file is invalid. Specify the correct file containing valid %s in PEM format.", "--key-location", "private key"), 211);
                }
            }
        }
        throw new HelpException("Invalid parameter for file name : " + param, 211);
    }

    private void checkParameters() {
        Object[] nameDetails = new Object[]{"--name", this.name, 240};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(nameDetails);
        if (this.filePublicCert == null || this.filePublicCert.isEmpty()) {
            throw new ValidationException("Provide value for --location parameter", 166);
        }
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "name", this.name, "cert-location", this.filePublicCert, "force", this.force);
        DumpHelper.dumpOperationList(this.user, "Upload certificate data", argsList.toArray());
    }

    protected void showWarningAndAskForConfirmationToContinue() {
        BufferedReader reader = this.createBufferedReader();
        System.out.print("WARNING: Uploading a private key remotely is not recommended because it poses a security risk! Confirm that you want to continue (y/n):");
        String continueStr = null;
        try {
            continueStr = reader.readLine();
        }
        catch (IOException e) {
            throw new CommandException("Upload aborted", e);
        }
        if (!"y".equalsIgnoreCase(continueStr)) {
            throw new CommandException("Upload canceled");
        }
    }

    public BufferedReader createBufferedReader() {
        return new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
    }
}

