/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.reverse.proxy;

import com.sap.core.certificate.manager.cmd.client.CertificateManagerRestClient;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.IListMappings;
import com.sap.core.certificate.manager.commons.model.ProxyHostMappingDTO;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ListProxyHostMappingByAppHost
implements IListMappings {
    String account;
    String applicationHost;
    List<ProxyHostMappingDTO> mappingsList = Collections.emptyList();

    ListProxyHostMappingByAppHost(String account, String applicationHost) {
        this.account = account;
        this.applicationHost = applicationHost;
    }

    @Override
    public void run(CertificateManagerRestClient restClient, String host) throws IOException {
        this.mappingsList = restClient.listProxyHostMappings(host, this.account, this.applicationHost);
    }

    @Override
    public void printOutput() {
        if (this.mappingsList != null && !this.mappingsList.isEmpty()) {
            System.out.println(String.format("Application with hostname '%s' is mapped to the following proxy host(s):", this.applicationHost));
            for (ProxyHostMappingDTO dto : this.mappingsList) {
                System.out.println("   " + dto.getProxy());
            }
        } else {
            System.out.println(String.format("No mappings found for application hostname '%s'.", this.applicationHost));
        }
    }

    @Override
    public String getGeneralError() {
        return String.format("The listing of proxy host mappings for application hostname '%s' in subaccount '%s' failed. The server is busy. Please, try again later.", this.applicationHost, this.account);
    }
}

