/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.reverse.proxy;

import com.sap.core.certificate.manager.cmd.client.CertificateManagerRestClient;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.IListMappings;
import com.sap.core.certificate.manager.commons.model.ProxyHostMappingDTO;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ListProxyHostMappingsByAccount
implements IListMappings {
    String account;
    String applicationHost;
    List<ProxyHostMappingDTO> dtoList = Collections.emptyList();

    ListProxyHostMappingsByAccount(String account) {
        this.account = account;
    }

    @Override
    public void run(CertificateManagerRestClient restClient, String host) throws IOException {
        this.dtoList = restClient.listProxyHostMappings(host, this.account);
    }

    @Override
    public void printOutput() {
        if (this.dtoList != null && !this.dtoList.isEmpty()) {
            int max = 0;
            int length = 0;
            for (ProxyHostMappingDTO dto : this.dtoList) {
                length = dto.getApplicationHost().length();
                if (length <= max) continue;
                max = length;
            }
            String formatString = "   %-" + max + "s - %s";
            System.out.println(String.format("Mappings in '%s' subaccount:", this.account));
            for (ProxyHostMappingDTO dto : this.dtoList) {
                System.out.println(String.format(formatString, dto.getApplicationHost(), dto.getProxy()));
            }
        } else {
            System.out.println(String.format("No mappings found in '%s'.", this.account));
        }
    }

    @Override
    public String getGeneralError() {
        return String.format("The listing of proxy host mappings in subaccount '%s' failed. The server is busy. Please, try again later.", this.account);
    }
}

