/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.reverse.proxy;

import com.sap.core.certificate.manager.cmd.client.CertificateManagerRestClient;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.IListMappings;
import com.sap.core.certificate.manager.commons.model.ProxyHostMappingDTO;
import java.io.IOException;
import java.util.List;

public class ListProxyHostMappingsByApplicationAndProxy
implements IListMappings {
    String account;
    String applicationHost;
    String proxy;
    List<ProxyHostMappingDTO> proxyHostMappings;

    ListProxyHostMappingsByApplicationAndProxy(String account, String applicationHost, String proxy) {
        this.account = account;
        this.applicationHost = applicationHost;
        this.proxy = proxy;
    }

    @Override
    public void run(CertificateManagerRestClient restClient, String host) throws IOException {
        this.proxyHostMappings = restClient.listProxyHostMappings(host, this.account, this.applicationHost, this.proxy);
    }

    @Override
    public void printOutput() {
        if (this.proxyHostMappings != null && !this.proxyHostMappings.isEmpty()) {
            ProxyHostMappingDTO proxyHostMapping = this.proxyHostMappings.get(0);
            System.out.println(String.format("Application with hostname '%s' is mapped to '%s'.", proxyHostMapping.getApplicationHost(), proxyHostMapping.getProxy()));
        } else {
            System.out.println(String.format("No mappings found for '%s' and '%s'", this.applicationHost, this.proxy));
        }
    }

    @Override
    public String getGeneralError() {
        return String.format("The listing of proxy host mapping for application hostname '%s' and proxy %s in subaccount '%s' failed. The server is busy. Please, try again later.", this.applicationHost, this.proxy, this.account);
    }
}

