/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.reverse.proxy;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.IListMappings;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.ListMappingsFactory;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.ReverseProxyCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ApplicationHostValidator;
import com.sap.core.certificate.manager.cmd.commands.validators.ProxyValidator;
import com.sap.core.certificate.manager.commons.exception.BadRequestException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Lists the proxy hosts to which the specified application hostname is mapped in the specified subaccount.")
public class ListProxyHostMappingsCommand
extends ReverseProxyCommand {
    @Parameter(names={"--app-host"}, description="Your application hostname (example: 'myapp.hana.ondemand.com').", validateWith=ApplicationHostValidator.class)
    private String applicationHost;
    @Parameter(names={"--proxy"}, description="On-premise reverse-proxy hostname and port. Separate proxy hostname and port with a colon (':'), for example: 'loc.corp:123'.", validateWith=ProxyValidator.class)
    private String proxy;

    @Override
    public void run() throws CommandException {
        super.run();
        IListMappings listCommand = null;
        try {
            listCommand = ListMappingsFactory.getInstance().getListCommand(this.account, this.applicationHost, this.proxy);
            listCommand.run(this.getRestClient(), this.host);
            listCommand.printOutput();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (BadRequestException e) {
            throw new CommandException(String.format(e.getMessage(), this.account), 400);
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(String.format("Application with hostname '%s' does not exist in subaccount '%s'.", this.applicationHost, this.account), 211);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException(listCommand.getGeneralError(), 166);
        }
    }

    @Override
    public String getName() {
        return "list-proxy-host-mappings";
    }

    @Override
    protected void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "application host", this.applicationHost);
        DumpHelper.dumpOperationList(this.user, "Lists the proxy hosts to which the specified application hostname is mapped in the specified subaccount.", argsList.toArray());
    }
}

