/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.reverse.proxy;

import com.beust.jcommander.ParameterException;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.commons.validation.ReverseProxyValidationUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.validator.AccountValidator;
import org.apache.http.client.HttpClient;
import org.apache.http.params.HttpParams;

public abstract class ReverseProxyCommand
extends BaseConsoleCommand {
    public static final String GROUP_NAME = "reverse-proxy";
    protected static final int SOCKET_TIMEOUT = 300000;

    @Override
    public String getGroup() {
        return GROUP_NAME;
    }

    @Override
    public void run() throws CommandException {
        this.dumpParameters();
        this.validateAccount();
    }

    protected void validateAccount() {
        AccountValidator accountValidator = new AccountValidator();
        accountValidator.validate("--account", this.account);
    }

    protected void validateProxyAndHost(String applicationHost, String proxy) {
        if (!ReverseProxyValidationUtil.isValueSpecified(applicationHost)) {
            throw new ParameterException("Parameter --app-host is not specified.");
        }
        if (!ReverseProxyValidationUtil.isValueSpecified(proxy)) {
            throw new ParameterException("Parameter --proxy is not specified.");
        }
    }

    protected abstract void dumpParameters();

    @Override
    protected HttpClient getHttpClient() throws ValidationException {
        HttpClient httpClient = super.getHttpClient();
        HttpParams params = httpClient.getParams();
        Integer timeout = params.getIntParameter("http.socket.timeout", 300000);
        if (timeout < 300000) {
            timeout = 300000;
        }
        params.setIntParameter("http.socket.timeout", timeout);
        return httpClient;
    }
}

