/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.reverse.proxy;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.reverse.proxy.ReverseProxyCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ApplicationHostValidator;
import com.sap.core.certificate.manager.cmd.commands.validators.ProxyValidator;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.ProxyHostMappingDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Deletes the mapping between an application host and an on-premise reverse proxy host and port.")
public class UnmapProxyHostCommand
extends ReverseProxyCommand {
    @Parameter(names={"--app-host"}, description="Your application hostname (example: 'myapp.hana.ondemand.com').", validateWith=ApplicationHostValidator.class)
    private String applicationHost;
    @Parameter(names={"--proxy"}, description="On-premise reverse-proxy hostname and port. Separate proxy hostname and port with a colon (':'), for example: 'loc.corp:123'.", validateWith=ProxyValidator.class)
    private String proxy;

    @Override
    public void run() throws CommandException {
        super.run();
        try {
            this.validateProxyAndHost(this.applicationHost, this.proxy);
            List<ProxyHostMappingDTO> proxyHostMappings = this.getRestClient().listProxyHostMappings(this.host, this.account, this.applicationHost, this.proxy);
            if (null == proxyHostMappings || proxyHostMappings.isEmpty()) {
                System.out.println(String.format("Nothing to unmap; application hostname '%s' is not mapped to proxy host '%s'.", this.applicationHost, this.proxy));
            } else {
                ProxyHostMappingDTO proxyHostMapping = proxyHostMappings.get(0);
                String guid = proxyHostMapping.getGuid();
                if (guid != null) {
                    this.getRestClient().unmapProxyHost(this.host, this.account, guid);
                    System.out.println(String.format("Application hostname '%s' was successfully unmapped from proxy host '%s'.", this.applicationHost, this.proxy));
                } else {
                    System.out.println(String.format("Nothing to unmap; application hostname '%s' is not mapped to proxy host '%s'.", this.applicationHost, this.proxy));
                }
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(String.format("Application with hostname '%s' does not exist in subaccount '%s'.", this.applicationHost, this.account), 211);
        }
        catch (ParameterException pe) {
            throw pe;
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException(String.format("Cannot unmap '%s' from '%s'.The server is busy. Please, try again later.", this.applicationHost, this.proxy), 166);
        }
    }

    @Override
    public String getName() {
        return "unmap-proxy-host";
    }

    @Override
    protected void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "application host", this.applicationHost, "proxy", this.proxy);
        DumpHelper.dumpOperationList(this.user, "Deletes the mapping between an application host and an on-premise reverse proxy host and port.", argsList.toArray());
    }
}

