/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.trusted.cas;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.trusted.cas.BaseCACommand;
import com.sap.core.certificate.manager.cmd.commands.trusted.cas.FileContent;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.DuplicateCertificatesException;
import com.sap.core.certificate.manager.commons.exception.NoGlobalIDException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.QuotaCAsPerBundleExceededException;
import com.sap.core.certificate.manager.commons.exception.QuotaExceededException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.model.CACertificatesDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Parameters(commandDescription="Uploads trusted CA X.509 certificates and adds them to a CA bundle")
public class AddCACommand
extends BaseCACommand {
    @Parameter(names={"--bundle"}, description="Name of a new or existing bundle in which CAs will be added. The name of a bundle must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9', \"_\" and \"-\". A bundle can hold up to 120 certificates.", required=true)
    private String bundle;
    @Parameter(names={"-l", "--location"}, description="Path to a file that contains one or more X.509 certificates of trusted CAs in PEM format.", required=true)
    private String fileName;

    @Override
    public String getName() {
        return "add-ca";
    }

    @Override
    public void run() throws CommandException {
        this.validateBundleName(this.bundle);
        FileContent fileContent = this.validateCAFileContent();
        try {
            CACertificatesDTO dto = this.createCACertificatesDTO(fileContent);
            this.getRestClient().addCACertificates(this.host, this.account, dto);
            System.out.println("[" + fileContent.getCertificatesCount() + "] trusted CA certificates from file '" + this.fileName + "' were added to CA bundle '" + this.bundle + "'.");
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException(String.format("Subaccount '%s' does not have any global quotas defined", this.account), 213);
        }
        catch (NoGlobalIDException e) {
            throw new CommandException(String.format("Subaccount '%s' does not have any global quotas defined", this.account), 213);
        }
        catch (QuotaExceededException e) {
            String message = this.constructQuotaExceededMessage(e);
            throw new CommandException(message, 212);
        }
        catch (QuotaCAsPerBundleExceededException e) {
            String message = e.getMessage() + "\n" + "Hint: Upload the certificates in separate bundles. Bind the separate bundles to different SSL hosts. Distribute the custom domain mappings between the SSL hosts.";
            throw new CommandException(message);
        }
        catch (DuplicateCertificatesException e) {
            throw new CommandException(e.getMessage() + "\n" + String.format("Hint: List the certificates in bundle '%s' with the list-cas command. Remove the already uploaded certificates from file '%s'", this.bundle, this.fileName));
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, e.getMessage(), 215);
        }
        catch (IOException e) {
            throw new CommandException("No trusted CA certificates were uploaded. " + e.getMessage());
        }
    }

    private FileContent validateCAFileContent() {
        File file = new File(this.fileName);
        this.checkFileLocation(file);
        try {
            String certPEM = this.readFileContent(file);
            List<X509Certificate> certs = this.parseCerts(certPEM);
            this.validateCertificatesCount(certs.size());
            this.validateCertificatesValidity(certs);
            return new FileContent(certPEM, certs.size());
        }
        catch (UnsupportedEncodingException e) {
            throw new CommandException("Error occurred while parsing content of '" + this.fileName + "' " + e.getMessage());
        }
    }

    private CACertificatesDTO createCACertificatesDTO(FileContent fileContent) {
        CACertificatesDTO dto = new CACertificatesDTO();
        dto.setAccount(this.account);
        dto.setClientCertBundleName(this.bundle);
        dto.setContent(fileContent.getContent());
        return dto;
    }

    private void checkFileLocation(File file) {
        if (!file.exists()) {
            throw new ValidationException("Invalid value in parameter --location. '" + this.fileName + "' was not found.");
        }
        if (!file.isFile()) {
            throw new ValidationException("Invalid value in parameter --location. '" + this.fileName + "' is not path to a file.");
        }
    }

    private List<X509Certificate> parseCerts(String certPEM) throws UnsupportedEncodingException {
        try {
            return this.certsUtil.parseCerts(certPEM);
        }
        catch (CertificateException e) {
            throw new ValidationException("Unable to parse '" + this.fileName + "'. It should contain only X.509 certificates in PEM format. " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    private String readFileContent(File file) {
        try {
            return FileUtils.readFileToString(file, "UTF-8");
        }
        catch (IOException e) {
            throw new CommandException("Error occurred while reading file '" + this.fileName + "' " + e.getMessage());
        }
    }

    private void validateCertificatesCount(int certsCount) {
        if (certsCount <= 0) {
            throw new ValidationException("Invalid value in parameter --location. '" + this.fileName + "' does not contain X.509 certificates in PEM format.");
        }
    }

    protected void validateCertificatesValidity(List<X509Certificate> certs) throws UnsupportedEncodingException {
        List<X509Certificate> expired = this.certsUtil.getExpiredCertificates(certs);
        if (expired.size() > 0) {
            this.throwExceptionForExpiredCertificates(expired);
        }
    }

    private String constructQuotaExceededMessage(QuotaExceededException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot upload trusted CA certificates. Cannot create bundle '");
        sb.append(this.bundle);
        sb.append("': ");
        sb.append(e.getMessage());
        return sb.toString();
    }

    private void throwExceptionForExpiredCertificates(List<X509Certificate> expired) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = null;
        PrintStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new PrintStream((OutputStream)baos, true, "UTF-8");
            out.println("Cannot upload trusted CA certificates. '" + this.fileName + "' contains invalid certificates:");
            this.outputUtil.printCertificates(out, expired);
            String message = new String(baos.toByteArray(), "UTF-8");
            throw new CommandException(message);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(baos);
            throw throwable;
        }
    }

    @Override
    protected void validateBundleName(String bundle) {
        Object[] bundleNameDetails = new Object[]{"--bundle", bundle, 30};
        ParameterValidator validator = new ParameterValidator();
        validator.validateWithSpecialCharacterWithoutDot(bundleNameDetails);
    }
}

