/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.trusted.cas;

import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.trusted.cas.PrintOutputUtil;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.util.X509CertificatesUtil;

public abstract class BaseCACommand
extends BaseConsoleCommand {
    public static final String PARAM_DESCRIPTION_REMOVE_CA_BUNDLE_NAME = "Name of the bundle that contains the CAs to be removed.";
    public static final String PARAM_LONG_EXPIRED_CERTS = "--expired";
    public static final String PARAM_LONG_EXPIRED_CERTS_DESCRIPTION = "Removes all expired trusted CA certificates. Takes no value.";
    public static final String PARAM_LONG_SERIAL_NUMBER = "--serial-number";
    public static final String PARAM_LONG_SERIAL_NUMBER_DESCRIPTION = "A comma-separated (,) list of the serial numbers of the CA certificates to be removed.";
    public static final String NO_CA_BUNDLES = "No CA bundles in subaccount '%s'. Subaccount quota: %d";
    public static final String NO_CA_BUNDLES_ASSIGNED_TO_SSL_HOSTS = "No CA bundles set to SSL Hosts in subaccount '%s'. \nTo list all bundles in subaccount '%s', specify parameter --all";
    protected static final String ERROR_LISTING_ALL_CA_BUNDLES = "Error encountered while retrieving all CA bundles in subaccount '%s'.\nSkip parameter --all to list only the bundles that are set to SSL Hosts.";
    protected static final String ERROR_LISTING_CA_BUNDLES_SET_TO_SSL_HOSTS = "Error encountered while retrieving CA bundles set to SSL Hosts in subaccount '%s'.";
    protected static final String ERROR_LISTING_CA_BUNDLE = "Error encountered while retrieving the trusted CA certificates in bundle '%s'";
    protected static final String HINT_QUOTA_CA_CERTS_PER_BUNDLE_EXCEEDED = "Hint: Upload the certificates in separate bundles. Bind the separate bundles to different SSL hosts. Distribute the custom domain mappings between the SSL hosts.";
    protected static final String HINT_DUPLICATE_CA_CERTS_IN_BUNDLE = "Hint: List the certificates in bundle '%s' with the list-cas command. Remove the already uploaded certificates from file '%s'";
    protected static final String BUNDLE_NOT_FOUND = "CA bundle '%s' was not found.";
    protected static final String ENTIRE_CA_BUNDLE_REMOVED = "CA bundle '%s' was removed.";
    protected static final String ALL_EXPIRED_CERTS_REMOVED = "All expired certificates were removed from bundle '%s'.";
    protected static final String CERT_BY_SERIAL_NUMBER_REMOVED = "Trusted CA certificate with serial number '%s' was removed from bundle '%s'.";
    protected static final String CERTS_BY_SERIAL_NUMBERS_REMOVED = "Trusted CA certificates with serial numbers '%s' were removed from bundle '%s'.";
    protected static final String ERROR_REMOVING_CERTS = "No trusted CA certificates were removed.";
    protected static final String HINT_BUNDLE_ASSIGNED_TO_SSL_HOST = "Hint: To unassign the bundle, run the command set-ssl-host with parameter '--ca-bundle %s:none'.";
    protected static final String NO_CONFIRMATION = "No confirmation";
    protected static final String NO_GLOBAL_QUOTA = "Subaccount '%s' does not have any global quotas defined";
    protected PrintOutputUtil outputUtil = new PrintOutputUtil();
    protected X509CertificatesUtil certsUtil = new X509CertificatesUtil();

    protected void validateBundleName(String bundle) {
        Object[] bundleNameDetails = new Object[]{"--bundle", bundle, 30};
        ParameterValidator validator = new ParameterValidator();
        validator.validateWithSpecialCharacter(bundleNameDetails);
    }
}

