/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.trusted.cas;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.trusted.cas.BaseCACommand;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.NoGlobalIDException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.model.CABundleDTO;
import com.sap.core.certificate.manager.commons.model.CABundlesDTO;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

@Parameters(commandDescription="Lists the trusted CA certificates in a bundle or the bundles that are set to SSL Hosts. Lists all bundles in the subaccount only in case parameter --all is specified.")
public class ListCAsCommand
extends BaseCACommand {
    @Parameter(names={"--all"}, description="Lists the names of all bundles in the subaccount.")
    private boolean allBundles;
    @Parameter(names={"--bundle"}, description="Name of the CA bundle that you want to view. Use the parameter to view a single bundle.")
    private String bundle;
    @Parameter(names={"-f", "--file-name"}, description="Path to a file where the CA bundle will be downloaded.")
    private String fileName;

    @Override
    public String getName() {
        return "list-cas";
    }

    @Override
    public void run() throws CommandException {
        this.validateCombinationOfSpecifiedParameters();
        try {
            if (this.bundle != null) {
                this.listBundleContent();
            } else {
                this.listBundleNames();
            }
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException(String.format("Subaccount '%s' does not have any global quotas defined", this.account), 213);
        }
        catch (NoGlobalIDException e) {
            throw new CommandException(String.format("Subaccount '%s' does not have any global quotas defined", this.account), 213);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, this.getGeneralErrorMsg(), 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, e.getMessage(), 215);
        }
        catch (IOException e) {
            throw new CommandException(this.getGeneralErrorMsg());
        }
    }

    private void validateCombinationOfSpecifiedParameters() {
        if (this.allBundles && this.bundle != null) {
            throw new ValidationException("Provide either --all or --bundle");
        }
        if (this.allBundles && this.fileName != null) {
            throw new ValidationException("Provide either --all or --bundle to download its content to the specified '" + this.fileName + "'");
        }
        if (this.bundle == null && this.fileName != null) {
            throw new ValidationException("Provide --bundle to download its content to the specified '" + this.fileName + "'");
        }
    }

    private void listBundleNames() throws IOException {
        if (this.allBundles) {
            this.listAllBundleNames();
        } else {
            this.listBundleNamesAssignedToSslHosts();
        }
    }

    private void listBundleContent() throws IOException {
        this.validateBundleName(this.bundle);
        this.validateFileName();
        try {
            String content = this.getRestClient().getCABundleContent(this.host, this.account, this.bundle);
            this.downloadBundleContent(content);
            List<X509Certificate> certificates = this.certsUtil.parseCerts(content);
            String numberOfCAsMessage = "Trusted CAs in bundle '" + this.bundle + "': " + certificates.size();
            this.outputUtil.printNumberOfCAs(System.out, numberOfCAsMessage);
            this.outputUtil.printCertificates(System.out, certificates);
            this.outputUtil.printNumberOfCAs(System.out, numberOfCAsMessage);
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(String.format("CA bundle '%s' was not found.", this.bundle));
        }
        catch (CertificateException e) {
            throw new CommandException("Error encountered while parsing the trusted CA certificates in bundle '" + this.bundle + "'");
        }
    }

    private void listAllBundleNames() throws IOException {
        CABundlesDTO allCABundles = this.getRestClient().listAllCABundles(this.host, this.account);
        List<CABundleDTO> bundles = allCABundles.getBundles();
        if (bundles == null || bundles.size() == 0) {
            System.out.println(String.format("No CA bundles in subaccount '%s'. Subaccount quota: %d", this.account, allCABundles.getTotalQuota()));
        } else {
            System.out.println("CA bundles in subaccount '" + this.account + "': " + bundles.size() + ". Subaccount quota: " + allCABundles.getTotalQuota());
            this.outputUtil.printBundles(System.out, bundles);
        }
    }

    private void listBundleNamesAssignedToSslHosts() throws IOException {
        CABundlesDTO allCABundles = this.getRestClient().listCABundlesAssignedToSslHosts(this.host, this.account);
        List<CABundleDTO> bundles = allCABundles.getBundles();
        if (bundles == null || bundles.size() == 0) {
            System.out.println(String.format("No CA bundles set to SSL Hosts in subaccount '%s'. \nTo list all bundles in subaccount '%s', specify parameter --all", this.account, this.account));
        } else {
            System.out.println("CA bundles set to SSL Hosts in subaccount '" + this.account + "': " + bundles.size() + ". Subaccount quota: " + allCABundles.getTotalQuota());
            System.out.println("To list all bundles in subaccount '" + this.account + "', specify parameter --all");
            this.outputUtil.printBundles(System.out, bundles);
        }
    }

    private void downloadBundleContent(String content) {
        if (this.fileName != null) {
            try {
                this.getFileIO(this.fileName).writeFileContent(content);
            }
            catch (IOException e) {
                throw new HelpException("Problem writing " + this.fileName + "!");
            }
        }
    }

    private void validateFileName() throws IOException {
        if (this.fileName != null) {
            this.appendBundleNameToFileIfNeeded();
            if (new File(this.fileName).exists()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
                System.out.print("File '" + this.fileName + "' already exists. Would you like to overwrite it (y/n)?");
                String shouldOverwrite = reader.readLine();
                if (!"y".equalsIgnoreCase(shouldOverwrite)) {
                    throw new CommandException("File '" + this.fileName + "' was not overwritten.", 0);
                }
            }
        }
    }

    private void appendBundleNameToFileIfNeeded() {
        File file = new File(this.fileName);
        if (file.isDirectory()) {
            file.mkdirs();
            this.fileName = this.fileName + File.separator + this.bundle + ".crt";
        }
    }

    private String getGeneralErrorMsg() {
        if (this.bundle != null) {
            return String.format("Error encountered while retrieving the trusted CA certificates in bundle '%s'", this.bundle);
        }
        return this.allBundles ? String.format("Error encountered while retrieving all CA bundles in subaccount '%s'.\nSkip parameter --all to list only the bundles that are set to SSL Hosts.", this.account) : String.format("Error encountered while retrieving CA bundles set to SSL Hosts in subaccount '%s'.", this.account);
    }
}

