/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.trusted.cas;

import com.sap.core.certificate.manager.commons.model.CABundleDTO;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class PrintOutputUtil {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String INDENTATION = "               ";
    public static final String SUBJECT_LABEL = "Subject      : ";
    public static final String ISSUER_LABEL = "Issuer       : ";
    public static final String SERIAL_NUMBER_LABEL = "Serial number: ";
    public static final String VALIDITY_LABEL = "Validity     : ";
    private final int MAX_LINE_LENGTH = 80 - "               ".length();
    public static final String NONE = "<none>";
    private static final String SEPARATOR = "---------------------------------------------------------------------";

    public void printBundles(PrintStream out, List<CABundleDTO> bundles) {
        Object[] bundlesArr = new Object[bundles.size() * 2];
        int index = 0;
        for (CABundleDTO bundle : bundles) {
            bundlesArr[index] = bundle.getName();
            bundlesArr[++index] = bundle.getSslHostDisplayName() == null ? NONE : bundle.getSslHostDisplayName();
            ++index;
        }
        DumpHelper.dumpOperationList(SEPARATOR, bundlesArr);
    }

    public void printCertificates(PrintStream out, List<X509Certificate> x509Certificates) {
        out.println(SEPARATOR);
        for (X509Certificate x509Certificate : x509Certificates) {
            this.printCertificateInfo(out, x509Certificate.getSubjectDN().getName(), x509Certificate.getIssuerDN().getName(), x509Certificate.getSerialNumber(), this.formatDate(x509Certificate.getNotBefore()), this.formatDate(x509Certificate.getNotAfter()));
        }
    }

    public void printNumberOfCAs(PrintStream out, String message) {
        out.println(SEPARATOR);
        out.print(message);
    }

    private void printCertificateInfo(PrintStream out, String subject, String issuer, BigInteger serialNumber, String fromDate, String toDate) {
        out.print(SUBJECT_LABEL);
        out.print(this.getOutputSeparatedWithNewLines(subject));
        out.print(ISSUER_LABEL);
        out.print(this.getOutputSeparatedWithNewLines(issuer));
        out.print(SERIAL_NUMBER_LABEL);
        out.println(serialNumber);
        out.print(VALIDITY_LABEL);
        out.println("from " + fromDate);
        out.print(INDENTATION);
        out.println("to   " + toDate);
        out.println(SEPARATOR);
    }

    private String formatDate(Date date) {
        return this.dateFormatter.format(date);
    }

    private String getOutputSeparatedWithNewLines(String str) {
        int length = str.length();
        int chunks = str.length() / this.MAX_LINE_LENGTH;
        if (chunks == 0 || length == this.MAX_LINE_LENGTH) {
            return str + NEW_LINE;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= chunks; ++i) {
            int endIndex;
            int beginIndex = i * this.MAX_LINE_LENGTH;
            int n = endIndex = (i + 1) * this.MAX_LINE_LENGTH < length ? (i + 1) * this.MAX_LINE_LENGTH : length;
            if (i > 0) {
                builder.append(INDENTATION);
            }
            builder.append(str.substring(beginIndex, endIndex));
            builder.append(NEW_LINE);
        }
        return builder.toString();
    }
}

