/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.trusted.cas;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.trusted.cas.BaseCACommand;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.NoExpiredCACertificatesInBundleException;
import com.sap.core.certificate.manager.commons.exception.NoGlobalIDException;
import com.sap.core.certificate.manager.commons.exception.NoQuotaDefinedException;
import com.sap.core.certificate.manager.commons.exception.NotFoundCACertificatesInBundleException;
import com.sap.core.certificate.manager.commons.exception.ResourceInUseException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

@Parameters(commandDescription="Removes trusted CAs from a bundle or deletes a whole bundle and all certificates in it")
public class RemoveCACommand
extends BaseCACommand {
    @Parameter(names={"--bundle"}, description="Name of the bundle that contains the CAs to be removed.", required=true)
    private String bundle;
    @Parameter(names={"--serial-number"}, description="A comma-separated (,) list of the serial numbers of the CA certificates to be removed.")
    private String serialNumber;
    @Parameter(names={"--expired"}, description="Removes all expired trusted CA certificates. Takes no value.")
    private boolean expired;

    @Override
    public String getName() {
        return "remove-ca";
    }

    @Override
    public void run() throws CommandException {
        try {
            this.validateBundleName(this.bundle);
            this.validateCombinationOfSpecifiedParameters();
            if (this.expired) {
                this.removeExpiredCACertificates();
                return;
            }
            if (this.serialNumber != null) {
                this.removeCACertificatesBySerialNumber();
                return;
            }
            this.removeEntireBundle();
        }
        catch (NoQuotaDefinedException e) {
            throw new CommandException(String.format("Subaccount '%s' does not have any global quotas defined", this.account), 213);
        }
        catch (NoGlobalIDException e) {
            throw new CommandException(String.format("Subaccount '%s' does not have any global quotas defined", this.account), 213);
        }
        catch (NoExpiredCACertificatesInBundleException e) {
            throw new CommandException(e.getMessage());
        }
        catch (NotFoundCACertificatesInBundleException e) {
            throw new CommandException(e.getMessage());
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(String.format("CA bundle '%s' was not found.", this.bundle));
        }
        catch (ResourceInUseException e) {
            throw new CommandException(e.getMessage() + "\n" + String.format("Hint: To unassign the bundle, run the command set-ssl-host with parameter '--ca-bundle %s:none'.", this.bundle));
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, e.getMessage(), 215);
        }
        catch (IOException e) {
            throw new CommandException("No trusted CA certificates were removed. " + e.getMessage());
        }
    }

    private void validateCombinationOfSpecifiedParameters() throws IOException {
        if (this.expired && this.serialNumber != null) {
            throw new ValidationException("Provide either --serial-number or --expired");
        }
        if (!this.expired && this.serialNumber == null) {
            this.askForConfirmationToRemoveEntireBundle();
        }
    }

    private void askForConfirmationToRemoveEntireBundle() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        System.out.print("Confirm that you want to remove entire CA bundle '" + this.bundle + "' : (y/n)");
        String shouldRemoveBundle = reader.readLine();
        if (!"y".equalsIgnoreCase(shouldRemoveBundle)) {
            throw new CommandException("No confirmation");
        }
    }

    private void removeExpiredCACertificates() throws IOException {
        this.getRestClient().removeExpiredCertificatesFromBundle(this.host, this.account, this.bundle);
        System.out.println(String.format("All expired certificates were removed from bundle '%s'.", this.bundle));
    }

    private void removeCACertificatesBySerialNumber() throws IOException {
        this.getRestClient().removeCertificatesBySerialNumberFromBundle(this.host, this.account, this.bundle, this.serialNumber);
        String successMsg = this.serialNumber.contains(",") ? String.format("Trusted CA certificates with serial numbers '%s' were removed from bundle '%s'.", this.serialNumber, this.bundle) : String.format("Trusted CA certificate with serial number '%s' was removed from bundle '%s'.", this.serialNumber, this.bundle);
        System.out.println(successMsg);
    }

    private void removeEntireBundle() throws IOException {
        this.getRestClient().removeBundle(this.host, this.account, this.bundle);
        System.out.println(String.format("CA bundle '%s' was removed.", this.bundle));
    }
}

