/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands.validators;

import com.sap.core.certificate.manager.commons.model.Constants;
import com.sap.core.certificate.manager.commons.validation.CustomDomainsValidationUtil;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.validator.routines.UrlValidator;

public class ParameterValidator {
    protected UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"});

    public void validate(Object[][] parameterToValidate) {
        for (Object[] ls : parameterToValidate) {
            String fieldName = (String)ls[0];
            String fieldValue = (String)ls[1];
            Integer expectedValue = (Integer)ls[2];
            this.validateLength(fieldName, fieldValue, expectedValue);
            this.validateName(fieldName, fieldValue, "[a-zA-Z]+[a-zA-Z0-9]*", " The value must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9'.");
        }
    }

    public void validateWithSpecialCharacter(Object[] parameterToValidate) {
        this.validateWithSpecialCharacter(parameterToValidate, "[a-zA-Z]+[a-zA-Z0-9\\._-]*", " The value must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9' \".\", \"_\" and \"-\".");
    }

    public void validateWithSpecialCharacterWithoutDot(Object[] parameterToValidate) {
        this.validateWithSpecialCharacter(parameterToValidate, "[a-zA-Z]+[a-zA-Z0-9_-]*", " The value must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9' \"_\" and \"-\".");
    }

    public void validateWithSpecialCharacter(Object[] parameterToValidate, String regex, String message) {
        String name = (String)parameterToValidate[0];
        String value = (String)parameterToValidate[1];
        Integer expectedLength = (Integer)parameterToValidate[2];
        this.validateLength(name, value, expectedLength);
        this.validateName(name, value, regex, message);
    }

    public void validateURL(String[][] parameterToValidate) {
        for (String[] str : parameterToValidate) {
            String name = str[0];
            String value = str[1];
            this.validateLength(name, value, 10000);
            String valueForValidation = value;
            if (!value.startsWith("https://")) {
                valueForValidation = "https://" + value;
            }
            if (this.urlValidator.isValid(valueForValidation)) continue;
            throw new ValidationException("Invalid parameter '" + value + "'; please provide correct value . For example: mysubaccountmyapp.hana.ondemand.com", 166);
        }
    }

    public void validateDistinguishName(String[] parameterToValidate) {
        String name = parameterToValidate[0];
        String value = parameterToValidate[1];
        this.validateLength(name, value, 10000);
        try {
            new LdapName(value);
        }
        catch (InvalidNameException e) {
            throw new ValidationException("Invalid DN " + value, 166);
        }
    }

    protected void validateName(String fieldName, String fieldValue, String regex, String message) {
        if (!CustomDomainsValidationUtil.validateName(fieldValue, regex)) {
            throw new ValidationException(String.format("Invalid value of parameter %s.", fieldName) + message, 166);
        }
    }

    public void validateLength(String fieldName, String fieldValue, int expectedValue) {
        if (fieldValue == null || fieldValue.isEmpty()) {
            throw new ValidationException("Expected a value for parameter " + fieldName, 166);
        }
        if (fieldValue.length() > expectedValue) {
            throw new ValidationException("Parameter '" + fieldName + "' should be not longer than " + expectedValue + " characters.", 166);
        }
    }

    public void validateKeysizeParameter(String keysize) {
        if (keysize != null) {
            int size = 0;
            try {
                size = Integer.parseInt(keysize);
            }
            catch (NumberFormatException nfe) {
                throw new ValidationException("Expected a numeric value for parameter --key-size", 166);
            }
            if (size < 2048) {
                throw new ValidationException("The value for parameter --key-size should be at least 2048 . Supported keypair sizes/lengths are " + Constants.ALLOWED_KEY_SIZES_TO_STRING, 166);
            }
        }
    }

    public void validateSignatureAlgorithmParameter(String algorithm) {
        if (algorithm != null) {
            for (String allowedAlgorithm : Constants.ALLOWED_SIGANTURE_ALGORITHMS) {
                if (!algorithm.equalsIgnoreCase(allowedAlgorithm)) continue;
                return;
            }
            throw new ValidationException("Incorrect value for parameter --signature-algorithm.The supported algorithms are " + Constants.ALLOWED_SIGANTURE_ALGORITMS_TO_STRING, 166);
        }
    }
}

