/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.FileArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarArchive
implements Archive {
    private final ClassLoader loader;
    private final URL url;
    private final JarFile jar;

    public JarArchive(ClassLoader loader, URL url) {
        try {
            this.loader = loader;
            this.url = url;
            URL u = url;
            String jarPath = url.getFile();
            if (jarPath.contains("!")) {
                jarPath = jarPath.substring(0, jarPath.indexOf("!"));
                u = new URL(jarPath);
            }
            this.jar = new JarFile(FileArchive.decode(u.getFile()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        ZipEntry entry;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((entry = this.jar.getEntry(className)) == null) {
            throw new ClassNotFoundException(className);
        }
        return this.jar.getInputStream(entry);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        return new JarIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JarIterator
    implements Iterator<Archive.Entry> {
        private final Enumeration<JarEntry> stream;
        private Archive.Entry next;

        private JarIterator() {
            this.stream = JarArchive.this.jar.entries();
        }

        private boolean advance() {
            if (this.next != null) {
                return true;
            }
            while (this.stream.hasMoreElements()) {
                JarEntry entry = this.stream.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.endsWith(".class")) continue;
                String className = entryName;
                if (entryName.endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                }
                if (className.contains(".")) continue;
                this.next = new ClassEntry(entry, className.replace('/', '.'));
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.advance();
        }

        @Override
        public Archive.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Archive.Entry entry = this.next;
            this.next = null;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private class ClassEntry
        implements Archive.Entry {
            private final String name;
            private final JarEntry entry;

            private ClassEntry(JarEntry entry, String name) {
                this.name = name;
                this.entry = entry;
            }

            public String getName() {
                return this.name;
            }

            public InputStream getBytecode() throws IOException {
                return JarArchive.this.jar.getInputStream(this.entry);
            }
        }
    }
}

