/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg;

import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.cloud.crypto.clientcert.cfg.json.UserMapping;
import com.sap.cloud.crypto.clientcert.osgi.ClientCertServiceAccessor;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertConfigurationProvider {
    static final Logger LOG = LoggerFactory.getLogger(ClientCertConfigurationProvider.class);
    private static final int MIN_INDEX = 1;
    public static final String TRUSTED_CAS_KEYSTORE = "trustedCAsKeystore";
    public static final String SEPARATOR = ".";
    public static final String USER_MAPPING = "userMapping";
    public static final String USER_MAPPING_WITH_SEPARATOR = "userMapping.";

    private static boolean containsConfiguration(Map<String, ?> options) {
        if (options != null && !options.isEmpty()) {
            Set<String> keys = options.keySet();
            for (String key : keys) {
                if (!key.startsWith(USER_MAPPING_WITH_SEPARATOR)) continue;
                return true;
            }
        }
        return false;
    }

    public ClientCertConfig getConfiguration(Map<String, ?> options) throws ClientCertConfigurationException {
        ClientCertConfig configuration = null;
        if (ClientCertConfigurationProvider.containsConfiguration(options)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading client certificate configuration from login module options:\n" + ClientCertConfigurationProvider.getOptionsForTrace(options));
            }
            KeyStore trustedCAsKeystore = null;
            if (options.containsKey(TRUSTED_CAS_KEYSTORE)) {
                Object keystoreValue = options.get(TRUSTED_CAS_KEYSTORE);
                if (!(keystoreValue instanceof KeyStore)) {
                    throw new ClientCertConfigurationException("Login module option 'trustedCAsKeystore' is not java.security.KeyStore: " + (keystoreValue == null ? null : keystoreValue.getClass()));
                }
                trustedCAsKeystore = (KeyStore)keystoreValue;
            }
            List<UserMapping> userMappings = ClientCertConfigurationProvider.parseUserMappings(options);
            configuration = new ClientCertConfig();
            configuration.setTrustedCAsKeystoreInstance(trustedCAsKeystore);
            configuration.setUserMappings(userMappings);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuration not found in the provided login module options, loading client certificate configuration for the persistent storage...");
            }
            configuration = ClientCertServiceAccessor.getTenantConfiguration();
        }
        ClientCertConfig.validate(configuration);
        if (LOG.isInfoEnabled()) {
            LOG.info("Loaded client certificate configuration: " + configuration);
        }
        return configuration;
    }

    private static List<UserMapping> parseUserMappings(Map<String, ?> options) throws ClientCertConfigurationException {
        Set<String> keys = options.keySet();
        TreeMap hashUserMappings = new TreeMap();
        for (String key : keys) {
            if (!key.startsWith(USER_MAPPING_WITH_SEPARATOR)) continue;
            String subKey = null;
            if (USER_MAPPING_WITH_SEPARATOR.equals(key)) {
                throw new ClientCertConfigurationException("Login module option '" + key + "' has unspecified subkey");
            }
            subKey = key.substring(key.indexOf(SEPARATOR) + 1);
            Integer index = null;
            if (UserMapping.supportedOptions.contains(subKey)) {
                index = 0;
            } else {
                int indexSeparatorSubKey = subKey.indexOf(SEPARATOR);
                if (indexSeparatorSubKey != -1) {
                    String indexFromSubKey = subKey.substring(0, indexSeparatorSubKey);
                    try {
                        index = Integer.parseInt(indexFromSubKey);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ClientCertConfigurationException("Login module option '" + key + "' must be with integer index");
                    }
                    if (index < 1) {
                        throw new ClientCertConfigurationException("Login module option '" + key + "' must have index >= " + 1);
                    }
                    if (!UserMapping.supportedOptions.contains(subKey = subKey.substring(indexSeparatorSubKey + 1))) {
                        throw new ClientCertConfigurationException("Login module option '" + key + "' has unsupported subkey '" + subKey + "', supported subkeys are: " + UserMapping.supportedOptions);
                    }
                } else {
                    throw new ClientCertConfigurationException("Login module option '" + key + "' has unsupported subkey '" + subKey + "', supported subkeys are: " + UserMapping.supportedOptions);
                }
            }
            HashMap userMapping = (HashMap)hashUserMappings.get(index);
            if (userMapping == null) {
                userMapping = new HashMap();
            }
            Object value = options.get(key);
            userMapping.put(subKey, value);
            hashUserMappings.put(index, userMapping);
        }
        ArrayList<UserMapping> userMappings = new ArrayList<UserMapping>();
        Set keysIndex = hashUserMappings.keySet();
        for (Integer keyIndex : keysIndex) {
            userMappings.add(new UserMapping((Map)hashUserMappings.get(keyIndex)));
        }
        return userMappings;
    }

    private static String getOptionsForTrace(Map<String, ?> options) {
        StringBuilder result = new StringBuilder();
        Object[] keys = options.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            String value = "" + options.get(key);
            if ("KeystorePassword".equals(key)) {
                value = "********";
            }
            result.append("  " + (String)key + ": " + value + "\r\n");
            ++n2;
        }
        return result.toString();
    }
}

