/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.cache;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.cache.DomainDBConfigurationData;
import com.sap.cloud.crypto.clientcert.cfg.cache.DomainDBHelper;
import com.sap.cloud.crypto.clientcert.cfg.cache.FileReader;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.core.jpaas.security.utils.connection.Connection;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import java.net.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(ClientCertConfigurationReader.class);
    private static final String TENANT_CONFIGURATION_PATH_TEMPLATE = "rest/configuration/tenant/%s/clientcert/clientcert_cfg.json";
    private static final String SUBSCRIPTION_CONFIGURATION_PATH_TEMPLATE = "rest/configuration/account/%s/application/%s/tenant/%s/clientcert/clientcert_cfg.json";
    private static ClientCertConfigurationReader INSTANCE = new ClientCertConfigurationReader();

    public static ClientCertConfigurationReader getInstance() {
        return INSTANCE;
    }

    public static void setInstance(ClientCertConfigurationReader instance) {
        INSTANCE = instance;
    }

    public ClientCertConfig fetchConfigurationForAccount(String tenantId) throws ClientCertConfigurationException {
        return this.fetchConfiguration(this.constructTenantPath(tenantId));
    }

    private String constructTenantPath(String tenantId) {
        return String.format(TENANT_CONFIGURATION_PATH_TEMPLATE, tenantId);
    }

    public ClientCertConfig fetchConfigurationForSubscription(String tenantId) throws ClientCertConfigurationException {
        return this.fetchConfiguration(this.constructSubscriptionPath(tenantId));
    }

    private String constructSubscriptionPath(String tenantId) throws ClientCertConfigurationException {
        String account = DomainDBHelper.getAccount();
        String application = DomainDBHelper.getApplication();
        if (account == null || application == null) {
            logger.error("Resolved account: [{}] and application: [{}] names.", (Object)account, (Object)application);
            throw new ClientCertConfigurationException("Account or application name cannot be resolved.");
        }
        return String.format(SUBSCRIPTION_CONFIGURATION_PATH_TEMPLATE, account, application, tenantId);
    }

    private ClientCertConfig fetchConfiguration(String cfgUrl) throws ClientCertConfigurationException {
        logger.debug("Reading clientcert login module configuration from Domain DB under path: [{}]", (Object)cfgUrl);
        Response response = this.executeRequestToDomainDB(cfgUrl);
        if (response.isOK()) {
            ClientCertConfig configuration = this.toClientCertConfiguration(response.asString());
            logger.debug("Obtained clientcert login module configuration from Domain DB:\n {[]}", (Object)configuration);
            return configuration;
        }
        if (response.is(404)) {
            logger.debug("Clientcert login module configuration is not found in the Domain DB under path: [{}]", (Object)cfgUrl);
            return null;
        }
        throw new ClientCertConfigurationException("Could not obtain clientcert login module configuration from Domain DB. Received status code: " + response.getStatus() + " and response:\n" + response.asString());
    }

    protected Response executeRequestToDomainDB(String path) {
        Connection<HttpURLConnection> connection = this.createConnection();
        return connection.execute(this.createRequest(path));
    }

    private Connection<HttpURLConnection> createConnection() {
        return new DomainDBConnection();
    }

    private Request<HttpURLConnection> createRequest(String path) {
        return (Request)new URLRequest.Builder().withPath(path).withGETMethod().build();
    }

    private ClientCertConfig toClientCertConfiguration(String responseBody) throws ClientCertConfigurationException {
        DomainDBConfigurationData configuration = this.toConfiguration(responseBody);
        if (configuration.isMalformed()) {
            logger.error("Unexpected response from DomainDB: {}", (Object)responseBody);
            throw new ClientCertConfigurationException("Clientcert login module configuration in Domain DB does not have content");
        }
        return FileReader.parseJSonConfiguration(configuration.toInputStream());
    }

    private DomainDBConfigurationData toConfiguration(String response) throws ClientCertConfigurationException {
        try {
            return (DomainDBConfigurationData)new Gson().fromJson(response, DomainDBConfigurationData.class);
        }
        catch (JsonSyntaxException exception) {
            logger.error("Unexpected response from DomainDB: {}", (Object)response);
            throw new ClientCertConfigurationException("Clientcert login module configuration in Domain DB is not a valid JSON.", exception);
        }
    }
}

