/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.cache;

import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.cache.ClientCertConfigurationReader;
import com.sap.cloud.crypto.clientcert.cfg.cache.FileReader;
import com.sap.cloud.crypto.clientcert.cfg.cache.SystemPropertiesReader;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationCacheReader
implements TenantCacheValueReader<ClientCertConfig> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationCacheReader.class);

    public ClientCertConfig readValue(String tenant, ClientCertConfig previouslyCachedConfiguration) {
        ClientCertConfig configuration;
        block9: {
            logger.debug("Reading persistent configuration for tenant: [{}]", (Object)tenant);
            configuration = null;
            try {
                logger.debug("Checking for configuration at subscription level");
                configuration = this.fetchConfigurationFromSubscriptionLevel(tenant);
                if (configuration != null) {
                    logger.debug("Found configuration at subscription level: [{}]", (Object)configuration);
                    return configuration;
                }
                logger.debug("Checking for configuration at account level");
                configuration = this.fetchConfigurationFromAccountLevel(tenant);
                if (configuration != null) {
                    logger.debug("Found configuration at account level: [{}]", (Object)configuration);
                    return configuration;
                }
            }
            catch (Exception exception) {
                logger.error("Failed to read persistent configuration: ", (Throwable)exception);
                if (previouslyCachedConfiguration == null) break block9;
                logger.warn("Will reuse the existing cached configuration: [{}]", (Object)previouslyCachedConfiguration);
                return previouslyCachedConfiguration;
            }
        }
        logger.debug("No persistent configuration found. Checking for configuration in system properties");
        try {
            configuration = this.readConfigurationFromSystemProperties();
            if (configuration != null) {
                logger.debug("Configuration loaded from system properties: [{}]", (Object)configuration);
                return configuration;
            }
        }
        catch (ClientCertConfigurationException exception) {
            logger.error("Failed to obtain configuration from system properties.", (Throwable)exception);
            return null;
        }
        logger.debug("No configuration from system properties. Checking for configuration in file system");
        try {
            configuration = this.readConfigurationFromFileSystem();
            logger.debug("Configuration loaded from file system: [{}]", (Object)configuration);
            return configuration;
        }
        catch (ClientCertConfigurationException exception) {
            logger.error("Failed to obtain configuration from file system: ", (Throwable)exception);
            return null;
        }
    }

    ClientCertConfig fetchConfigurationFromAccountLevel(String tenant) throws ClientCertConfigurationException {
        return ClientCertConfigurationReader.getInstance().fetchConfigurationForAccount(tenant);
    }

    ClientCertConfig fetchConfigurationFromSubscriptionLevel(String tenant) throws ClientCertConfigurationException {
        return ClientCertConfigurationReader.getInstance().fetchConfigurationForSubscription(tenant);
    }

    ClientCertConfig readConfigurationFromSystemProperties() throws ClientCertConfigurationException {
        return SystemPropertiesReader.getConfiguration();
    }

    ClientCertConfig readConfigurationFromFileSystem() throws ClientCertConfigurationException {
        return FileReader.getConfiguration();
    }
}

