/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainDBHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DomainDBHelper.class);
    private static Properties spaceProps = null;

    static String getAccount() {
        String account = DomainDBHelper.getSpaceProperties().getProperty("jpSpace");
        if (account == null) {
            LOG.error("Could not perform operation on subscription level, because the account property is empty");
        }
        return account;
    }

    static String getApplication() {
        String application = DomainDBHelper.getSpaceProperties().getProperty("jpApp");
        if (application == null) {
            LOG.error("Could not perform operation on subscription level, because the application property is empty");
        }
        return application;
    }

    private static synchronized Properties getSpaceProperties() {
        if (spaceProps == null) {
            File file = new File("space.properties");
            spaceProps = new Properties();
            try {
                spaceProps.load(new FileInputStream(file));
            }
            catch (IOException e) {
                LOG.error("Problem while loading properties from file: space.properties", (Throwable)e);
            }
        }
        return spaceProps;
    }
}

