/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationNotFoundExeption;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReader {
    private static final Logger LOG = LoggerFactory.getLogger(FileReader.class);
    private static final String CONFIG_DIR = "config_master" + File.separator + "com.sap.cloud.crypto.clientcert";
    private static final String JSON_FILE_NAME = "clientcert_cfg.json";
    private static final String JSON_FILE_PATHNAME = String.valueOf(CONFIG_DIR) + File.separator + "clientcert_cfg.json";

    private static final InputStream readJSonFile() throws ClientCertConfigurationException {
        File file = new File(JSON_FILE_PATHNAME);
        if (!file.exists()) {
            throw new ClientCertConfigurationNotFoundExeption("Configuration file with name clientcert_cfg.json does not exist in " + CONFIG_DIR);
        }
        if (!file.isFile()) {
            throw new ClientCertConfigurationException("Configuration file with name clientcert_cfg.json is not a file");
        }
        FileInputStream result = null;
        try {
            result = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ClientCertConfigurationException("Unable to read configuration file: clientcert_cfg.json", e);
        }
        return result;
    }

    public static ClientCertConfig parseJSonConfiguration(InputStream input) throws ClientCertConfigurationException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(input, "UTF-8");
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setPrettyPrinting();
            Gson gson = gsonBuilder.create();
            ClientCertConfig clientCertConfig = (ClientCertConfig)gson.fromJson((Reader)reader, ClientCertConfig.class);
            return clientCertConfig;
        }
        catch (Exception e) {
            throw new ClientCertConfigurationException("Unable to parse JSON stream", e);
        }
        finally {
            block11: {
                try {
                    if (reader != null) {
                        reader.close();
                    } else {
                        input.close();
                    }
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("Cannot close JSON configuration stream", (Throwable)e);
                }
            }
        }
    }

    public static synchronized ClientCertConfig getConfiguration() throws ClientCertConfigurationException {
        InputStream is = null;
        ClientCertConfig result = null;
        try {
            is = FileReader.readJSonFile();
            result = FileReader.parseJSonConfiguration(is);
            return result;
        }
        catch (ClientCertConfigurationException exc) {
            throw exc;
        }
        catch (Exception e) {
            throw new ClientCertConfigurationException("Failed to read configuration from file system.", e);
        }
    }
}

