/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.cache;

import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.cloud.crypto.clientcert.cfg.json.UserMapping;
import com.sap.cloud.crypto.clientcert.osgi.ClientCertServiceAccessor;
import com.sap.cloud.crypto.keystore.api.KeyStoreService;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesReader {
    private static final String SUBJECT_AND_ISSUER = "SubjectAndIssuer";
    private static final String WHOLE_CERT = "wholeCert";
    private static final String CN_ISSUER = "CN@Issuer";
    private static final String CN = "CN";
    private static final String MAPPING_MODE_SYSTEM_PROPERTY_KEY = "com.sap.cloud.crypto.clientcert.mapping_mode";
    private static final String KEYSTORE_NAME_SYSTEM_PROPERTY_KEY = "com.sap.cloud.crypto.clientcert.keystore_name";
    private static final Logger LOG = LoggerFactory.getLogger(SystemPropertiesReader.class);

    public static ClientCertConfig getConfiguration() throws ClientCertConfigurationException {
        String mappingMode = System.getProperty(MAPPING_MODE_SYSTEM_PROPERTY_KEY);
        if (mappingMode == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No configuration found in system properties.");
            }
            return null;
        }
        String keystoreName = System.getProperty(KEYSTORE_NAME_SYSTEM_PROPERTY_KEY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read system properties values: \ncom.sap.cloud.crypto.clientcert.mapping_mode = " + mappingMode + ",\n" + KEYSTORE_NAME_SYSTEM_PROPERTY_KEY + " = " + keystoreName);
        }
        ArrayList<UserMapping> userMappings = new ArrayList<UserMapping>();
        ClientCertConfig configuration = new ClientCertConfig();
        if (CN.equalsIgnoreCase(mappingMode)) {
            if (keystoreName == null) {
                UserMapping userMapping = SystemPropertiesReader.createUserMappingCN();
                userMappings.add(userMapping);
            } else {
                List<String> certificateAliases = SystemPropertiesReader.getCertificateEntryAliases(keystoreName);
                for (String alias : certificateAliases) {
                    UserMapping userMapping = SystemPropertiesReader.createUserMappingCN();
                    userMapping.setTrustedCAKeystoreEntry(alias);
                    userMappings.add(userMapping);
                }
                configuration.setTrustedCAsKeystoreName(keystoreName);
            }
        } else if (CN_ISSUER.equalsIgnoreCase(mappingMode)) {
            if (keystoreName == null) {
                throw new ClientCertConfigurationException("com.sap.cloud.crypto.clientcert.keystore_name is mandatory for the mapping mode CN@Issuer but it is not configured.");
            }
            List<String> certificateAliases = SystemPropertiesReader.getCertificateEntryAliases(keystoreName);
            for (String alias : certificateAliases) {
                UserMapping userMapping = SystemPropertiesReader.createUserMappingCN();
                userMapping.setTrustedCAKeystoreEntry(alias);
                userMapping.setUserSuffix("@" + alias);
                userMappings.add(userMapping);
            }
            configuration.setTrustedCAsKeystoreName(keystoreName);
        } else if (WHOLE_CERT.equalsIgnoreCase(mappingMode)) {
            if (keystoreName == null) {
                throw new ClientCertConfigurationException("com.sap.cloud.crypto.clientcert.keystore_name is mandatory for the mapping mode wholeCert but it is not configured.");
            }
            UserMapping userMapping = SystemPropertiesReader.createUserMappingWholeCert(keystoreName, UserMapping.WholeCertComparison.binary);
            userMappings.add(userMapping);
        } else if (SUBJECT_AND_ISSUER.equalsIgnoreCase(mappingMode)) {
            if (keystoreName == null) {
                throw new ClientCertConfigurationException("com.sap.cloud.crypto.clientcert.keystore_nameis mandatory for the mapping mode SubjectAndIssuer but it is not configured.");
            }
            UserMapping userMapping = SystemPropertiesReader.createUserMappingWholeCert(keystoreName, UserMapping.WholeCertComparison.subjectAndIssuer);
            userMappings.add(userMapping);
        } else {
            throw new ClientCertConfigurationException("Invalid value for com.sap.cloud.crypto.clientcert.mapping_mode: " + mappingMode + ". The supported values are" + CN + ", " + CN_ISSUER + ", " + WHOLE_CERT + ", " + SUBJECT_AND_ISSUER);
        }
        configuration.setUserMappings(userMappings);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created clientcert login module configuration from system properties:\n" + configuration);
        }
        return configuration;
    }

    private static UserMapping createUserMappingWholeCert(String keystoreName, UserMapping.WholeCertComparison type) {
        UserMapping userMapping = new UserMapping();
        userMapping.setGetUserFrom(UserMapping.UserMappingType.wholeCert);
        userMapping.setWholeCertKeystoreName(keystoreName);
        userMapping.setWholeCertComparison(type);
        return userMapping;
    }

    private static UserMapping createUserMappingCN() {
        UserMapping userMapping = new UserMapping();
        userMapping.setGetUserFrom(UserMapping.UserMappingType.subjectDN);
        userMapping.setCertificateAttribute(CN);
        return userMapping;
    }

    private static List<String> getCertificateEntryAliases(String keystoreName) throws ClientCertConfigurationException {
        KeyStore keystore = null;
        try {
            KeyStoreService keystoreService = ClientCertServiceAccessor.getKeystoreService();
            keystore = keystoreService.getKeyStore(keystoreName, null);
        }
        catch (Exception e) {
            throw new ClientCertConfigurationException("Could not get the keystore service.", e);
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<String> enumeration = keystore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!keystore.isCertificateEntry(alias)) continue;
                result.add(alias);
            }
            Collections.sort(result);
        }
        catch (KeyStoreException e) {
            throw new ClientCertConfigurationException("Error while reading from keystore " + keystoreName, e);
        }
        return result;
    }
}

