/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.json;

import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationNotFoundExeption;
import com.sap.cloud.crypto.clientcert.cfg.json.UserMapping;
import java.security.KeyStore;
import java.util.List;

public class ClientCertConfig {
    private String trustedCAsKeystore;
    private List<UserMapping> userMappings;
    private KeyStore trustedCAsKeystoreInstance;

    public KeyStore getTrustedCAsKeystoreInstance() {
        return this.trustedCAsKeystoreInstance;
    }

    public void setTrustedCAsKeystoreInstance(KeyStore keystore) {
        this.trustedCAsKeystoreInstance = keystore;
    }

    public void setUserMappings(List<UserMapping> userMappings) {
        this.userMappings = userMappings;
    }

    public String getTrustedCAsKeystoreName() {
        return this.trustedCAsKeystore;
    }

    public void setTrustedCAsKeystoreName(String trustedCAsKeystore) {
        this.trustedCAsKeystore = trustedCAsKeystore;
    }

    public boolean isTrustedCAsKeystoreSpecified() {
        return this.trustedCAsKeystore != null && this.trustedCAsKeystore.trim().length() > 0 || this.trustedCAsKeystoreInstance != null;
    }

    public List<UserMapping> getUserMappings() {
        return this.userMappings;
    }

    public static void validate(ClientCertConfig config) throws ClientCertConfigurationException {
        if (config == null) {
            throw new ClientCertConfigurationNotFoundExeption("No configuration found");
        }
        if (config.userMappings == null || config.userMappings.isEmpty()) {
            throw new ClientCertConfigurationException("No userMappings found in the configuration");
        }
        if (!config.isTrustedCAsKeystoreSpecified()) {
            if (config.userMappings.size() > 1) {
                throw new ClientCertConfigurationException("Only one user mapping is allowed, when trustedCAsKeystore is not specified. Found " + config.userMappings.size() + " configured user mappings");
            }
            UserMapping userMapping = config.userMappings.get(0);
            String trustedCAKeystoreEntry = userMapping.getTrustedCAKeystoreEntry();
            if (trustedCAKeystoreEntry != null && trustedCAKeystoreEntry.trim().length() > 0) {
                throw new ClientCertConfigurationException("It is not allowed to specify trustedCAKeystoreEntry in the user mapping, when trustedCAsKeystore is not configured");
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n").append("[");
        if (this.trustedCAsKeystore != null) {
            result.append("\n").append("  trustedCAsKeystore: ").append(this.trustedCAsKeystore);
        }
        result.append("\n").append("  userMappings: [");
        if (this.userMappings != null) {
            for (UserMapping singleMapping : this.userMappings) {
                result.append("\n").append("    ").append("[").append("\n");
                result.append(singleMapping.toString("      "));
                result.append("    ").append("]");
            }
        }
        result.append("\n").append("  ]");
        result.append("\n").append("]");
        return result.toString();
    }
}

