/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.cfg.json;

import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserMapping {
    private String trustedCAKeystoreAlias;
    private String trustedCAKeystoreEntry;
    private UserMappingType getUserFrom;
    private String certificateAttribute;
    private String userPrefix;
    private String userSuffix;
    private WholeCertComparison wholeCertComparison = WholeCertComparison.binary;
    private String wholeCertKeystore;
    private KeyStore wholeCertKeystoreInstance;
    public static final String CERTIFICATE_ATTRIBUTE = "certificateAttribute";
    public static final String GET_USER_FROM = "getUserFrom";
    public static final String USER_PREFIX = "userPrefix";
    public static final String USER_SUFIX = "userSuffix";
    public static final String TRUSTED_CAS_KEYSTORE_ENTRY = "trustedCAKeystoreEntry";
    public static final String TRUSTED_CAS_KEYSTORE_ALIAS = "trustedCAKeystoreAlias";
    public static final String WHOLE_CERT_KEYSTORE = "wholeCertKeystore";
    public static final String WHOLE_CERT_COMPARISON = "wholeCertComparison";
    public static final List<String> supportedOptions = new ArrayList<String>();

    static {
        supportedOptions.add(CERTIFICATE_ATTRIBUTE);
        supportedOptions.add(GET_USER_FROM);
        supportedOptions.add(USER_PREFIX);
        supportedOptions.add(USER_SUFIX);
        supportedOptions.add(TRUSTED_CAS_KEYSTORE_ENTRY);
        supportedOptions.add(TRUSTED_CAS_KEYSTORE_ALIAS);
        supportedOptions.add(WHOLE_CERT_KEYSTORE);
        supportedOptions.add(WHOLE_CERT_COMPARISON);
    }

    public UserMapping() {
    }

    public UserMapping(Map<String, Object> options) throws ClientCertConfigurationException {
        Set<String> keys = options.keySet();
        for (String key : keys) {
            Object value = options.get(key);
            if (key.equals(CERTIFICATE_ATTRIBUTE)) {
                this.certificateAttribute = (String)value;
                continue;
            }
            if (key.equals(GET_USER_FROM)) {
                try {
                    this.getUserFrom = UserMappingType.valueOf((String)value);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new ClientCertConfigurationException("Unknown value '" + value + "' for option '" + GET_USER_FROM + "', supported values are: " + Arrays.toString((Object[])UserMappingType.values()), ex);
                }
            }
            if (key.equals(USER_PREFIX)) {
                this.userPrefix = (String)value;
                continue;
            }
            if (key.equals(USER_SUFIX)) {
                this.userSuffix = (String)value;
                continue;
            }
            if (key.equals(TRUSTED_CAS_KEYSTORE_ENTRY)) {
                this.trustedCAKeystoreEntry = (String)value;
                continue;
            }
            if (key.equals(TRUSTED_CAS_KEYSTORE_ALIAS)) {
                this.trustedCAKeystoreAlias = (String)value;
                continue;
            }
            if (key.equals(WHOLE_CERT_KEYSTORE)) {
                if (value == null) {
                    throw new ClientCertConfigurationException("The value of option 'wholeCertKeystore' must be not null instance of java.security.KeyStore");
                }
                if (!(value instanceof KeyStore)) {
                    throw new ClientCertConfigurationException("The value of option 'wholeCertKeystore' is not an instance of java.security.KeyStore, it is instance of '" + value.getClass().getName() + "'");
                }
                this.wholeCertKeystoreInstance = (KeyStore)value;
                continue;
            }
            if (!key.equals(WHOLE_CERT_COMPARISON)) continue;
            try {
                this.wholeCertComparison = WholeCertComparison.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ClientCertConfigurationException("Unknown value '" + value + "' for option '" + WHOLE_CERT_COMPARISON + "', supported values are: " + Arrays.toString((Object[])WholeCertComparison.values()), e);
            }
        }
    }

    public void setTrustedCAKeystoreEntry(String trustedCAKeystoreEntry) {
        this.trustedCAKeystoreEntry = trustedCAKeystoreEntry;
    }

    public void setGetUserFrom(UserMappingType getUserFrom) {
        this.getUserFrom = getUserFrom;
    }

    public void setCertificateAttribute(String certificateAttribute) {
        this.certificateAttribute = certificateAttribute;
    }

    public void setUserSuffix(String userSuffix) {
        this.userSuffix = userSuffix;
    }

    public void setWholeCertComparison(WholeCertComparison wholeCertComparison) {
        this.wholeCertComparison = wholeCertComparison;
    }

    public void setWholeCertKeystoreName(String wholeCertKeystore) {
        this.wholeCertKeystore = wholeCertKeystore;
    }

    public String getWholeCertKeystoreName() {
        return this.wholeCertKeystore;
    }

    public synchronized KeyStore getWholeCertKeystoreInstance() {
        return this.wholeCertKeystoreInstance;
    }

    public WholeCertComparison getWholeCertComparisonMethod() {
        return this.wholeCertComparison;
    }

    public String getUserPrefix() {
        return this.userPrefix;
    }

    public String getUserSuffix() {
        return this.userSuffix;
    }

    public String getTrustedCAKeystoreEntry() {
        if (this.trustedCAKeystoreEntry != null) {
            return this.trustedCAKeystoreEntry;
        }
        return this.trustedCAKeystoreAlias;
    }

    public UserMappingType getGetUserFrom() {
        return this.getUserFrom;
    }

    public String getCertificateAttribute() {
        return this.certificateAttribute;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String indent) {
        StringBuilder result = new StringBuilder();
        result.append(indent).append("userMappingType: ").append(this.getUserFrom == null ? null : this.getUserFrom.toString()).append("\n");
        if (this.getTrustedCAKeystoreEntry() != null) {
            result.append(indent).append("keystoreEntryAlias: ").append(this.getTrustedCAKeystoreEntry()).append("\n");
        }
        if (this.certificateAttribute != null) {
            result.append(indent).append("certificateAttribute: ").append(this.certificateAttribute).append("\n");
        }
        if (this.userPrefix != null) {
            result.append(indent).append("userPrefix: ").append(this.userPrefix).append("\n");
        }
        if (this.userSuffix != null) {
            result.append(indent).append("userSuffix: ").append(this.userSuffix).append("\n");
        }
        if (this.getUserFrom == UserMappingType.wholeCert) {
            if (this.wholeCertComparison != null) {
                result.append(indent).append("wholeCertComparison: ").append(this.wholeCertComparison.name()).append("\n");
            }
            if (this.wholeCertKeystore != null) {
                result.append(indent).append("wholeCertKeystore: ").append(this.wholeCertKeystore.toString()).append("\n");
            }
        }
        return result.toString();
    }

    public static enum UserMappingType {
        subjectDN,
        wholeCert;

    }

    public static enum WholeCertComparison {
        binary,
        subjectAndIssuer;

    }
}

