/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.lm;

import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationException;
import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationNotFoundExeption;
import com.sap.cloud.crypto.clientcert.cfg.ClientCertConfigurationProvider;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.cloud.crypto.clientcert.cfg.json.UserMapping;
import com.sap.cloud.crypto.clientcert.lm.ClientCertPrincipal;
import com.sap.cloud.crypto.clientcert.lm.ClientCertUtil;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.security.um.service.api.ModifiableUserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.modify.ModifiableUser;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import com.sap.security.um.user.modify.UnsupportedUserNameException;
import com.sap.security.um.user.modify.UserAlreadyExistsException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertLoginModule
implements LoginModule {
    static final Logger LOG = LoggerFactory.getLogger(ClientCertLoginModule.class);
    private ClientCertPrincipal principal;
    private X509Certificate[] clientCertificateChain;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackhandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackhandler;
        this.options = options;
    }

    @Override
    public boolean abort() throws LoginException {
        this.principal = null;
        this.clientCertificateChain = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principal != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Authentication with client certificate was successful - the following Principal will be added to the Subject: " + (Object)((Object)this.principal));
            }
            this.cacheUser(this.principal.getName());
            this.subject.getPrincipals().add((Principal)((Object)this.principal));
            this.subject.getPublicCredentials().add(this.clientCertificateChain);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication with client certificate was not successful - return false for the commit method");
        }
        return false;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            ClientCertConfig configuration;
            X509Certificate clientCertificate;
            this.clientCertificateChain = this.getClientCertificates();
            if (this.clientCertificateChain != null && this.clientCertificateChain.length > 0 && this.clientCertificateChain[0] != null) {
                clientCertificate = this.clientCertificateChain[0];
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received client certificate: " + clientCertificate);
                }
            } else {
                throw new LoginException("Client certificate is not available in the request");
            }
            try {
                configuration = new ClientCertConfigurationProvider().getConfiguration(this.options);
            }
            catch (ClientCertConfigurationNotFoundExeption e) {
                LOG.info("Could not load client certificate configuration ", (Throwable)e);
                LoginException loginException = new LoginException("Could not load client certificate configuration");
                loginException.initCause(e);
                throw loginException;
            }
            catch (ClientCertConfigurationException e) {
                LOG.error("Could not load client certificate configuration ", (Throwable)e);
                LoginException loginException = new LoginException("Could not load client certificate configuration");
                loginException.initCause(e);
                throw loginException;
            }
            UserMapping userMapping = null;
            if (configuration.isTrustedCAsKeystoreSpecified()) {
                KeyStore trustedCAKeystore = ClientCertUtil.getTrustedCAKeystore(configuration, this.options);
                int i = 0;
                while (i < this.clientCertificateChain.length) {
                    userMapping = ClientCertUtil.getSuitableUserMapping(this.clientCertificateChain[i], configuration, trustedCAKeystore);
                    if (userMapping != null) break;
                    ++i;
                }
                if (userMapping == null) {
                    throw new LoginException("User mapping suitable for the received certificate is not found. None of the configured user mappings has trusted CA issuing the received client certificate");
                }
            } else {
                userMapping = configuration.getUserMappings().get(0);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Trusted CAs keystore is not configured. The login module will accept the received client certificate as trusted");
                }
            }
            String principalName = ClientCertUtil.getUserName(clientCertificate, userMapping);
            this.principal = new ClientCertPrincipal(principalName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Client certificate login module resolves the received client certificate to user: " + principalName);
            }
        }
        catch (LoginException le) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClientCertLoginModule failed with exception\n", (Throwable)le);
            }
            throw le;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        try {
            Set<X509Certificate[]> publicCredentials = this.subject.getPublicCredentials(X509Certificate[].class);
            if (publicCredentials != null) {
                Iterator<X509Certificate[]> iterator = publicCredentials.iterator();
                while (iterator.hasNext()) {
                    this.subject.getPublicCredentials().remove(iterator.next());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not remove X509Certificate public credentials from the Subject on logout", (Throwable)e);
        }
        return true;
    }

    private void cacheUser(String userName) {
        try {
            ModifiableUserProvider userProvider;
            if (LOG.isDebugEnabled()) {
                LOG.debug("User {} will be stored in the session", (Object)userName);
            }
            if ((userProvider = ModifiableUserManagementAccessor.getModifiableUserProvider()) != null) {
                ModifiableUser user = userProvider.getModifiableUser(userName);
                if (user == null) {
                    user = userProvider.createUser(userName);
                }
                userProvider.persistUser(user);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("User {} was created and saved", (Object)userName);
                }
            } else {
                LOG.error("No ModifiableUserProvider found. Cannot cache the authenticated user.");
            }
        }
        catch (PersistenceException e) {
            LOG.warn("Could not cache the authenticated user '" + userName + "'", (Throwable)e);
        }
        catch (UnsupportedUserNameException e) {
            LOG.warn("Could not cache the authenticated user because the provided name '" + userName + "' is not supported.", (Throwable)e);
        }
        catch (UserAlreadyExistsException e) {
            LOG.warn("Could not cache the authenticated user '" + userName + "', because such already exists.", (Throwable)e);
        }
    }

    private X509Certificate[] getClientCertificates() throws LoginException {
        HttpGetterCallback callback = new HttpGetterCallback();
        callback.setType((byte)4);
        try {
            try {
                this.callbackHandler.handle(new Callback[]{callback});
            }
            catch (NullPointerException e) {
                LOG.warn("Could not handle HttpGetterCallback with type CERTIFICATE without a name. Will try with name javax.servlet.request.X509Certificate.", (Throwable)e);
                callback.setName("javax.servlet.request.X509Certificate");
                this.callbackHandler.handle(new Callback[]{callback});
            }
        }
        catch (Exception e) {
            LOG.error("Could not obtain client certificate from the request", (Throwable)e);
            LoginException le = new LoginException("Could not obtain client certificate from the request");
            le.initCause(e);
            throw le;
        }
        X509Certificate[] result = (X509Certificate[])callback.getValue();
        return result;
    }
}

