/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.lm;

import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.cloud.crypto.clientcert.cfg.json.UserMapping;
import com.sap.cloud.crypto.clientcert.lm.ClientCertLoginModule;
import com.sap.cloud.crypto.clientcert.osgi.ClientCertServiceAccessor;
import com.sap.cloud.crypto.clientcert.verifier.ClientTrustVerifier;
import com.sap.cloud.crypto.keystore.api.KeyStoreService;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.login.LoginException;

public class ClientCertUtil {
    private static final String MULTI_CERTIFICATE_ALIAS_SUFFIX_PATTERN = "(.+)\\[\\[\\((\\d+)\\)\\]\\]$";
    private static final String REPLACEABLE_MULTI_CERTIFICATE_ALIAS_SUFFIX_PATTERN = "\\[\\[\\((\\d+)\\)\\]\\]$";
    private static final String EMPTY_STRING = "";
    public static final String LM_OPTION_NAME_KEYSTORE_PASSWORD = "KeystorePassword";
    public static final String ISSUER_DN = "%issuerDN%";
    public static final String ISSUER_CN = "%issuerCN%";
    public static final String RDN_CN = "CN";

    static KeyStore getTrustedCAKeystore(ClientCertConfig configuration, Map<String, ?> options) throws LoginException {
        KeyStore result = configuration.getTrustedCAsKeystoreInstance();
        if (result != null) {
            return result;
        }
        Object passwordObj = options.get(LM_OPTION_NAME_KEYSTORE_PASSWORD);
        char[] passwordCharArray = null;
        if (passwordObj != null && passwordObj instanceof String) {
            String password = (String)passwordObj;
            if (!EMPTY_STRING.equals(password)) {
                passwordCharArray = password.toCharArray();
                if (ClientCertLoginModule.LOG.isDebugEnabled()) {
                    ClientCertLoginModule.LOG.debug("Keystore password was provided as login module option '{}'", (Object)LM_OPTION_NAME_KEYSTORE_PASSWORD);
                }
            } else if (ClientCertLoginModule.LOG.isDebugEnabled()) {
                ClientCertLoginModule.LOG.debug("Keystore password was not provided as login module option '{}'. Integrity check of trusted CA keystore will not be performed", (Object)LM_OPTION_NAME_KEYSTORE_PASSWORD);
            }
        } else if (ClientCertLoginModule.LOG.isDebugEnabled()) {
            ClientCertLoginModule.LOG.debug("Keystore password was not provided as login module option '{}'. Integrity check of trusted CA keystore will not be performed", (Object)LM_OPTION_NAME_KEYSTORE_PASSWORD);
        }
        String keystoreName = configuration.getTrustedCAsKeystoreName();
        try {
            KeyStoreService keystoreService = ClientCertServiceAccessor.getKeystoreService();
            result = keystoreService.getKeyStore(keystoreName, passwordCharArray);
            return result;
        }
        catch (Exception e) {
            LoginException le = new LoginException("Could not obtain trusted CA keystore with the configured name: " + keystoreName);
            le.initCause(e);
            throw le;
        }
    }

    static KeyStore getWholeCertKeystore(UserMapping mappingRule) throws LoginException {
        KeyStore result = mappingRule.getWholeCertKeystoreInstance();
        if (result != null) {
            return result;
        }
        String keystoreName = mappingRule.getWholeCertKeystoreName();
        try {
            KeyStoreService keystoreService = ClientCertServiceAccessor.getKeystoreService();
            char[] passwordCharArray = null;
            result = keystoreService.getKeyStore(keystoreName, passwordCharArray);
            return result;
        }
        catch (Exception e) {
            LoginException le = new LoginException("Could not obtain WholeCertKeystore instance using the configured name: " + keystoreName);
            le.initCause(e);
            throw le;
        }
    }

    static UserMapping getSuitableUserMapping(X509Certificate clientCertificate, ClientCertConfig configuration, KeyStore trustedCAKeystore) throws LoginException {
        List<UserMapping> userMappings = configuration.getUserMappings();
        if (userMappings == null) {
            throw new LoginException("Configuration for client certificate authentication does not contain any user mapping entries");
        }
        UserMapping suitableUserMapping = null;
        for (UserMapping userMapping : userMappings) {
            String trustedCAKeystoreAlias = userMapping.getTrustedCAKeystoreEntry();
            boolean isTrustedCA = ClientTrustVerifier.verifyClient(trustedCAKeystore, clientCertificate, trustedCAKeystoreAlias);
            if (!isTrustedCA) continue;
            suitableUserMapping = userMapping;
            break;
        }
        return suitableUserMapping;
    }

    static String getUserName(X509Certificate clientCertificate, UserMapping userMapping) throws LoginException {
        User user;
        UserProvider userProvider;
        try {
            userProvider = UserManagementAccessor.getUserProvider();
        }
        catch (PersistenceException e) {
            ClientCertLoginModule.LOG.error("Could not obtain UserProvider", (Throwable)e);
            LoginException loginException = new LoginException("Could not obtain UserProvider");
            loginException.initCause(e);
            throw loginException;
        }
        try {
            UserMapping.UserMappingType userMappingType = userMapping.getGetUserFrom();
            switch (userMappingType) {
                case subjectDN: {
                    String subjectDN = clientCertificate.getSubjectX500Principal().getName();
                    String subjectDNAttribute = userMapping.getCertificateAttribute();
                    if (subjectDNAttribute == null || subjectDNAttribute.length() < 1) {
                        String userName = ClientCertUtil.addPrefixAndSuffix(clientCertificate, subjectDN, userMapping);
                        user = userProvider.getUser(userName);
                        if (user == null) {
                            throw new LoginException("Could not find user by searching with: '" + userName + "', obtained from certificate subject DN");
                        }
                    } else {
                        if (!RDN_CN.equalsIgnoreCase(subjectDNAttribute)) {
                            throw new LoginException("The configured certificate attribute: '" + subjectDNAttribute + "' in the user mapping is not supported. Currently supported value is only: '" + RDN_CN + "'");
                        }
                        String subjectDNAttributeValue = ClientCertUtil.extractRdnValue(subjectDN, subjectDNAttribute);
                        String userName = ClientCertUtil.addPrefixAndSuffix(clientCertificate, subjectDNAttributeValue, userMapping);
                        user = userProvider.getUser(userName);
                        if (user == null) {
                            throw new LoginException("Could not find user by searching with: '" + userName + "', obtained from certificate subject DN attribute with name: " + subjectDNAttribute);
                        }
                    }
                    break;
                }
                case wholeCert: {
                    if (userMapping.getWholeCertKeystoreInstance() != null || userMapping.getWholeCertKeystoreName() != null) {
                        String userName = userMapping.getWholeCertComparisonMethod() == UserMapping.WholeCertComparison.binary ? ClientCertUtil.resolveWithBinaryComparison(userMapping, clientCertificate) : ClientCertUtil.resolveWithSubjectAndIssuerComparison(userMapping, clientCertificate);
                        userName = ClientCertUtil.removeKeystoreAliasSuffixFromUserName(userName);
                        user = userProvider.getUser(userName = ClientCertUtil.addPrefixAndSuffix(clientCertificate, userName, userMapping));
                        if (user == null) {
                            throw new LoginException("Could not find user by searching with: '" + userName + "', obtained using mapping WholeCertKeystore");
                        }
                    } else {
                        user = userProvider.getUser(clientCertificate);
                        if (user == null) {
                            throw new LoginException("Could not find user by searching with certificate:\n" + clientCertificate);
                        }
                    }
                    break;
                }
                default: {
                    throw new LoginException("Unknown user mapping type: " + (Object)((Object)userMappingType));
                }
            }
        }
        catch (PersistenceException e) {
            ClientCertLoginModule.LOG.warn("Could not find user.\n  User mapping: " + userMapping + "\n  Received client certificate: " + clientCertificate, (Throwable)e);
            LoginException loginException = new LoginException("Could not find user");
            loginException.initCause(e);
            throw loginException;
        }
        String userName = user.getName();
        return userName;
    }

    private static String resolveWithSubjectAndIssuerComparison(UserMapping userMapping, X509Certificate clientCertificate) throws LoginException {
        KeyStore wholeCertKeystore = ClientCertUtil.getWholeCertKeystore(userMapping);
        try {
            Enumeration<String> aliases = wholeCertKeystore.aliases();
            while (aliases.hasMoreElements()) {
                String entryAlias = aliases.nextElement();
                if (!wholeCertKeystore.isCertificateEntry(entryAlias)) continue;
                X509Certificate possibleMatch = (X509Certificate)wholeCertKeystore.getCertificate(entryAlias);
                if (!clientCertificate.getSubjectX500Principal().equals(possibleMatch.getSubjectX500Principal()) || !clientCertificate.getIssuerX500Principal().equals(possibleMatch.getIssuerX500Principal())) continue;
                if (ClientCertLoginModule.LOG.isDebugEnabled()) {
                    ClientCertLoginModule.LOG.debug("Found keystore entry with alias '" + entryAlias + "' that matches the Subject and Issuer DNs of the received certificate");
                }
                return entryAlias;
            }
        }
        catch (KeyStoreException e) {
            String errorMessage = "Could not find user because the supplied WholeCertKeystore instance is faulty.\n  User mapping: " + userMapping + "\n" + "  Received client certificate: " + clientCertificate;
            ClientCertLoginModule.LOG.warn(errorMessage, (Throwable)e);
            LoginException exc = new LoginException(errorMessage);
            exc.initCause(e);
            throw exc;
        }
        throw new LoginException("Could not find user by searching into the supplied WholeCertKeystore instance with comparison method " + (Object)((Object)userMapping.getWholeCertComparisonMethod()));
    }

    private static String resolveWithBinaryComparison(UserMapping userMapping, X509Certificate clientCertificate) throws LoginException {
        String userName;
        KeyStore wholeCertKeystore = ClientCertUtil.getWholeCertKeystore(userMapping);
        try {
            userName = wholeCertKeystore.getCertificateAlias(clientCertificate);
        }
        catch (KeyStoreException e) {
            String errorMessage = "Could not find user because the supplied WholeCertKeystore instance is faulty.\n  User mapping: " + userMapping + "\n" + "  Received client certificate: " + clientCertificate;
            ClientCertLoginModule.LOG.warn(errorMessage, (Throwable)e);
            LoginException exc = new LoginException(errorMessage);
            exc.initCause(e);
            throw exc;
        }
        if (userName == null) {
            throw new LoginException("Could not find user by searching into the supplied WholeCertKeystore instance with comparison method " + (Object)((Object)userMapping.getWholeCertComparisonMethod()));
        }
        if (ClientCertLoginModule.LOG.isDebugEnabled()) {
            ClientCertLoginModule.LOG.debug("Found keystore entry with alias '" + userName + "' that matches the received client certificate using comparison method 'binary'");
        }
        return userName;
    }

    private static String removeKeystoreAliasSuffixFromUserName(String userName) {
        if (userName.matches(MULTI_CERTIFICATE_ALIAS_SUFFIX_PATTERN)) {
            return userName.replaceFirst(REPLACEABLE_MULTI_CERTIFICATE_ALIAS_SUFFIX_PATTERN, EMPTY_STRING);
        }
        return userName;
    }

    private static String addPrefixAndSuffix(X509Certificate clientCertificate, String userName, UserMapping userMapping) throws LoginException {
        String userSuffix;
        String userPrefix = userMapping.getUserPrefix();
        if (userPrefix != null && (userPrefix = userPrefix.trim()).length() > 0) {
            if (ClientCertLoginModule.LOG.isDebugEnabled()) {
                ClientCertLoginModule.LOG.debug("Adding prefix '{}' to user name '{}'", (Object)userPrefix, (Object)userName);
            }
            userPrefix = ClientCertUtil.replacePrefixAndSuffix(clientCertificate, userPrefix);
            userName = String.valueOf(userPrefix) + userName;
        }
        if ((userSuffix = userMapping.getUserSuffix()) != null && (userSuffix = userSuffix.trim()).length() > 0) {
            if (ClientCertLoginModule.LOG.isDebugEnabled()) {
                ClientCertLoginModule.LOG.debug("Adding suffix '{}' to user name '{}'", (Object)userSuffix, (Object)userName);
            }
            userSuffix = ClientCertUtil.replacePrefixAndSuffix(clientCertificate, userSuffix);
            userName = String.valueOf(userName) + userSuffix;
        }
        return userName;
    }

    private static String replacePrefixAndSuffix(X509Certificate clientCertificate, String mapping) throws LoginException {
        String issuerDN = clientCertificate.getIssuerX500Principal().getName();
        mapping = mapping.replace(ISSUER_DN, issuerDN);
        String issuerCN = ClientCertUtil.extractRdnValue(clientCertificate.getIssuerX500Principal().getName(), RDN_CN);
        mapping = mapping.replace(ISSUER_CN, issuerCN);
        return mapping;
    }

    private static String extractRdnValue(String subjectDN, String rdnName) throws LoginException {
        LdapName ldapName;
        try {
            ldapName = new LdapName(subjectDN);
        }
        catch (InvalidNameException e) {
            ClientCertLoginModule.LOG.error("Could not parse subject DN:" + subjectDN, (Throwable)e);
            LoginException loginException = new LoginException("Could not parse the received certificate subject DN: " + subjectDN);
            loginException.initCause(e);
            throw loginException;
        }
        List<Rdn> rdns = ldapName.getRdns();
        for (Rdn rdn : rdns) {
            if (rdn.size() == 1) {
                if (!rdn.getType().equalsIgnoreCase(rdnName)) continue;
                return rdn.getValue().toString();
            }
            if (rdn.size() <= 1) continue;
            Attributes rdnAttributes = rdn.toAttributes();
            NamingEnumeration<? extends Attribute> rdnAttributesEnumeration = rdnAttributes.getAll();
            while (rdnAttributesEnumeration.hasMoreElements()) {
                Attribute rdnAttribute = (Attribute)rdnAttributesEnumeration.nextElement();
                if (!rdnAttribute.getID().equalsIgnoreCase(rdnName)) continue;
                try {
                    return rdnAttribute.get().toString();
                }
                catch (NamingException e) {
                    LoginException loginException = new LoginException("Could not extract the value of RDN: " + rdnName);
                    loginException.initCause(e);
                    throw loginException;
                }
            }
        }
        throw new LoginException("RDN with name '" + rdnName + "' is not found in the received certificate subject DN: " + subjectDN);
    }
}

