/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.osgi;

import com.sap.cloud.crypto.clientcert.cfg.cache.ConfigurationCacheReader;
import com.sap.cloud.crypto.clientcert.cfg.json.ClientCertConfig;
import com.sap.cloud.crypto.clientcert.osgi.TenantHelper;
import com.sap.core.jpaas.security.utils.cache.TenantCache;
import com.sap.core.jpaas.security.utils.cache.TenantCacheEntry;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import java.util.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertService {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCertService.class);
    private static final String KEY_TENANT_MAPPING_TARGET = "tenant_mapping_target";
    private static final String KEY_TENANT_MAPPING_SOURCE = "tenant_mapping_source";
    private static final String KEY_CACHE_VALIDITY_PERIOD = "configuration_cache_validity_period";
    private static final String KEY_CACHE_LAST_ACCESS_TIMEOUT = "configuration_cache_last_access_timeout";
    private static final String KEY_FORCE_CACHE_INVALIDE = "configuration_force_cache_invalidate";
    private static final int DEFAULT_CACHE_VALIDITY_PERIOD_IN_SECONDS = 120;
    private static final int DEFAULT_CACHE_LAST_ACCESS_TIMEOUT_IN_SECONDS = 1800;
    private static final ClientCertService instance = new ClientCertService();
    private int cacheValidityPeriodInSeconds = 120;
    private int cacheLastAccessTimeoutInSeconds = 1800;
    private String tenantMappingSource = null;
    private String tenantMappingTarget = null;
    private TenantCache<ClientCertConfig> cache = new TenantCache((TenantCacheValueReader)new ConfigurationCacheReader(), (long)this.cacheValidityPeriodInSeconds * 1000L, (long)this.cacheLastAccessTimeoutInSeconds * 1000L);

    static final ClientCertService getInstance() {
        return instance;
    }

    private int getInteger(Dictionary props, String key, int defaultValue) {
        String number = (String)props.get(key);
        try {
            return Integer.parseInt(number);
        }
        catch (Exception e) {
            LOG.warn("Expected integer property '" + key + "' but the configured value is: " + number, (Throwable)e);
            return defaultValue;
        }
    }

    synchronized void reloadConfiguration(Dictionary props) {
        LOG.debug("Updating clientcert service, with properties: " + props);
        boolean isCacheInvalid = false;
        if (props != null) {
            this.cacheValidityPeriodInSeconds = this.getInteger(props, KEY_CACHE_VALIDITY_PERIOD, 120);
            this.cacheLastAccessTimeoutInSeconds = this.getInteger(props, KEY_CACHE_LAST_ACCESS_TIMEOUT, 1800);
            this.tenantMappingSource = (String)props.get(KEY_TENANT_MAPPING_SOURCE);
            this.tenantMappingTarget = (String)props.get(KEY_TENANT_MAPPING_TARGET);
            isCacheInvalid = "true".equalsIgnoreCase((String)props.get(KEY_FORCE_CACHE_INVALIDE));
        }
        if (isCacheInvalid) {
            LOG.info("Configuration cache has been invalidated...");
            this.cache = new TenantCache((TenantCacheValueReader)new ConfigurationCacheReader(), (long)this.cacheValidityPeriodInSeconds * 1000L, (long)this.cacheLastAccessTimeoutInSeconds * 1000L);
        } else {
            this.cache.setLastAccessTimeout((long)this.cacheLastAccessTimeoutInSeconds * 1000L);
            this.cache.setValueTimeout((long)this.cacheValidityPeriodInSeconds * 1000L);
        }
    }

    protected String getSafeTenantId() {
        String currentTenantID = TenantHelper.getTenantId();
        if (this.tenantMappingSource != null && this.tenantMappingTarget != null && this.tenantMappingSource.equalsIgnoreCase(currentTenantID)) {
            LOG.debug("current tenant id '" + currentTenantID + "' replaced with configured tenant id: " + this.tenantMappingTarget);
            return this.tenantMappingTarget;
        }
        return currentTenantID;
    }

    public synchronized ClientCertConfig getTenantConfiguration() {
        TenantCacheEntry cacheEntry = this.cache.getTenantCacheEntry(this.getSafeTenantId());
        return (ClientCertConfig)cacheEntry.getValue();
    }
}

