/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.osgi;

import com.sap.cloud.crypto.clientcert.osgi.ClientCertServiceAccessor;
import com.sap.cloud.crypto.keystore.api.KeyStoreService;
import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatActivator
implements InternalComponentLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatActivator.class);

    public void start() {
        ClassLoader classloader = this.getClass().getClassLoader();
        ServiceLoader<KeyStoreService> loader = ServiceLoader.load(KeyStoreService.class, classloader);
        Iterator<KeyStoreService> iterator = loader.iterator();
        if (iterator.hasNext()) {
            ClientCertServiceAccessor.setKeyStoreService(iterator.next());
        } else {
            LOG.warn("Keystore service is not found with class loader " + classloader);
        }
    }

    public void stop() {
        ClientCertServiceAccessor.setKeyStoreService(null);
    }
}

