/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.clientcert.verifier;

import java.security.KeyStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTrustVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTrustVerifier.class);

    public static boolean verifyClient(KeyStore trustedCAs, X509Certificate clientCertificate, String trustedCAKeystoreAlias) {
        block12: {
            try {
                if (trustedCAs.isCertificateEntry(trustedCAKeystoreAlias)) break block12;
                LOG.warn("Could not verify the received client certificate against the configured trusted CA alias '" + trustedCAKeystoreAlias + "', because the entry under this alias is not a certificate!");
                return false;
            }
            catch (Exception e) {
                LOG.warn("Could not verify the received client certificate - failed to obtain keystore entry under alias '" + trustedCAKeystoreAlias + "'", (Throwable)e);
                return false;
            }
        }
        X509Certificate trustedCACertificate = (X509Certificate)trustedCAs.getCertificate(trustedCAKeystoreAlias);
        if (trustedCACertificate == null) {
            LOG.warn("Could not verify the received client certificate against the configured trusted CA alias '" + trustedCAKeystoreAlias + "', because entry with this alias is not present in trustedCAs keystore!");
            return false;
        }
        X500Principal clientCertificateIssuer = clientCertificate.getIssuerX500Principal();
        X500Principal trustedCACertificateSubject = trustedCACertificate.getSubjectX500Principal();
        if (!trustedCACertificateSubject.equals(clientCertificateIssuer)) {
            LOG.debug("Received client certificate with issuer DN '{}', is not issued by the trusted CA represented with certificate with subject DN '{}'", (Object)clientCertificateIssuer, (Object)trustedCACertificateSubject);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("issuer certificate '" + trustedCAKeystoreAlias + "': " + trustedCACertificate);
        }
        try {
            trustedCACertificate.checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            LOG.warn("Could not verify the received client certificate against the configured trusted CA alias '" + trustedCAKeystoreAlias + "', because the certificate under this alias is not yet valid - it has validity not before: " + trustedCACertificate.getNotBefore(), (Throwable)e);
            return false;
        }
        catch (CertificateExpiredException e) {
            LOG.warn("Could not verify the received client certificate against the configured trusted CA alias '" + trustedCAKeystoreAlias + "', because the certificate under this alias is expired - it has validity not after: " + trustedCACertificate.getNotAfter(), (Throwable)e);
            return false;
        }
        try {
            clientCertificate.verify(trustedCACertificate.getPublicKey());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Signature of the client certificate is verified, the client is trusted.");
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Signature verification of the received client certificate failed", (Throwable)e);
            return false;
        }
    }
}

