/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation;

import com.sap.core.connectivity.api.validation.DestinationValidation;
import com.sap.core.connectivity.apiext.validation.DestinationValidatorFactory;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DestinationValidationImpl
implements DestinationValidation {
    public List<String> validate(String destinationType, Properties destinationProperties) {
        Validator validator = this.getValidator(destinationType);
        ViolationSet violationSet = validator.validate(destinationProperties);
        if (violationSet == null) {
            return Collections.emptyList();
        }
        Set<Violation> violations = violationSet.getErrors();
        return this.collectErrorMessages(violations);
    }

    Validator getValidator(String destinationType) {
        return DestinationValidatorFactory.getValidator(destinationType);
    }

    private List<String> collectErrorMessages(Set<Violation> violations) {
        ArrayList<String> errorMessages = new ArrayList<String>(violations.size());
        for (Violation violation : violations) {
            errorMessages.add(violation.getMessage());
        }
        return errorMessages;
    }
}

