/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation;

import com.sap.core.connectivity.apiext.validation.NotSupportedDestinationTypeException;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.composite.HttpValidator;
import com.sap.core.connectivity.apiext.validation.validators.composite.LdapValidator;
import com.sap.core.connectivity.apiext.validation.validators.composite.MailValidator;
import com.sap.core.connectivity.apiext.validation.validators.composite.RfcValidator;
import com.sap.core.connectivity.apiext.validation.validators.consts.CommonConstants;

public class DestinationValidatorFactory {
    public static Validator getValidator(String destinationType) {
        if ("HTTP".equals(destinationType)) {
            return new HttpValidator();
        }
        if ("MAIL".equals(destinationType)) {
            return new MailValidator();
        }
        if ("RFC".equals(destinationType)) {
            return new RfcValidator();
        }
        if ("LDAP".equals(destinationType)) {
            return new LdapValidator();
        }
        throw new NotSupportedDestinationTypeException(String.valueOf(destinationType) + " " + "is not supported Destination Type. Allowed Types are:" + " " + ValidValuesFormatter.format(CommonConstants.allowedDestinationTypes));
    }
}

