/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.common;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class BasicPropertiesValidator
extends Validator {
    private String key;
    private boolean isMandatory;
    private ViolationType violationIfMandatoryAndMissing;
    private boolean canBeEmpty;

    public BasicPropertiesValidator(String key, boolean isMandatory, ViolationType violaionTypeIfMandatoryAndMissing, boolean canBeEmpty) {
        this.key = key;
        this.isMandatory = isMandatory;
        this.violationIfMandatoryAndMissing = violaionTypeIfMandatoryAndMissing;
        this.canBeEmpty = canBeEmpty;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        String value;
        if (this.isMandatory && !properties.containsKey(this.key)) {
            return ViolationSet.createViolationSet(new Violation(this.violationIfMandatoryAndMissing, Messages.getMessage("PropertyMissing", this.key), Severity.ERROR));
        }
        if (properties.containsKey(this.key) && !this.canBeEmpty && (value = properties.getProperty(this.key).trim()).isEmpty()) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.EMPTY_STRING, Messages.getMessage("ValueIsEmptyString", this.key), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

