/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.common;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class BooleanValidator
extends Validator {
    private String propertyKey;
    private boolean isMandatory;

    public BooleanValidator(String propertyKey, boolean isMandatory) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("Cannot validate properties. Argument passed to validator is null.");
        }
        this.propertyKey = propertyKey.trim();
        this.isMandatory = isMandatory;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        boolean propertyExists = properties.containsKey(this.propertyKey);
        if (this.isMandatory && !propertyExists) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.MANDATORY_BOOLEAN_PROPERTY_MISSING, Messages.getMessage("PropertyMissing", this.propertyKey), Severity.ERROR));
        }
        if (propertyExists) {
            return this.checkBooleanValue(properties);
        }
        return ViolationSet.emptyViolationSet();
    }

    private ViolationSet checkBooleanValue(Properties properties) {
        String value = properties.getProperty(this.propertyKey).trim();
        if (!value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.VALUE_OF_BOOLEAN_PROPERTY_NOT_VALID, Messages.getMessage("BooleanPropertyNotValid", this.propertyKey, value), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

