/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.common;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.validators.consts.CommonConstants;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class DestinationProviderValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey("DestinationProvider")) {
            return ViolationSet.emptyViolationSet();
        }
        String value = properties.getProperty("DestinationProvider").trim();
        if (!CommonConstants.allowedDestinationProviders.contains(value)) {
            Violation invalidDestinationProvider = new Violation(ViolationType.DESTINATION_PROVIDER_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "DestinationProvider", ValidValuesFormatter.format(CommonConstants.allowedDestinationProviders)), Severity.ERROR);
            return ViolationSet.createViolationSet(invalidDestinationProvider);
        }
        return ViolationSet.emptyViolationSet();
    }
}

