/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.common;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.utils.ValidValuesFormatter;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Set;

public class FilePathValidator
extends Validator {
    private String propertyKey;
    private Set<String> customAllowedExtensions;

    public FilePathValidator(String propertyName, Set<String> customAllowedExtensions) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Cannot validate properties. The property name passed to validator is null.");
        }
        if (customAllowedExtensions == null || customAllowedExtensions.isEmpty()) {
            throw new IllegalArgumentException("Cannot validate properties. The allowed extensions passed to validator missing.");
        }
        this.propertyKey = propertyName.trim();
        this.customAllowedExtensions = customAllowedExtensions;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (properties.containsKey(this.propertyKey)) {
            String value = properties.getProperty(this.propertyKey).trim();
            try {
                if (value.matches("[ ]*")) {
                    throw new URISyntaxException(value, "Input cannot be empty");
                }
                new URI(value);
                File file = new File(value);
                String extension = null;
                int fileExtensionPosition = file.getName().lastIndexOf(".");
                if (fileExtensionPosition != -1) {
                    extension = file.getName().substring(fileExtensionPosition + 1);
                }
                if (extension == null) {
                    return ViolationSet.createViolationSet(new Violation(ViolationType.FILE_EXTENSION_MISSING, Messages.getMessage("FileExtensionMissing", this.propertyKey), Severity.ERROR));
                }
                if (!this.customAllowedExtensions.contains(extension.toLowerCase())) {
                    return ViolationSet.createViolationSet(new Violation(ViolationType.FILE_EXTENSION_NOT_VALID, Messages.getMessage("FileExtensionNotValid", this.propertyKey, value, ValidValuesFormatter.format(this.customAllowedExtensions)), Severity.ERROR));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.PATH_IS_NOT_VALID, Messages.getMessage("PathNotValid", this.propertyKey, value), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

