/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.common;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class NameValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey("Name")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.NAME_MISSING, Messages.getMessage("MissingElementNameErrorMSG", new Object[0]), Severity.ERROR));
        }
        String value = properties.getProperty("Name").trim();
        if (properties.getProperty("Name").trim().isEmpty()) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.EMPTY_NAME, Messages.getMessage("MissingDestinationName", new Object[0]), Severity.ERROR));
        }
        if (value.length() > 200) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.NAME_TOO_LONG, Messages.getMessage("NameTooLong", "Name", 200), Severity.ERROR));
        }
        if (!value.matches("(([\\w-]+)|([\\w-]+(\\.(?i)(props|properties))$))")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.NAME_DOES_NOT_MATCH_REGEX, Messages.getMessage("NameDoesNotMatchRegEx", new Object[0]), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

