/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.common;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class TypeValidator
extends Validator {
    private String validType;

    public TypeValidator(String validType) {
        if (validType == null) {
            throw new IllegalArgumentException("Cannot validate properties. Argument passed to validator is null.");
        }
        this.validType = validType;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        if (!properties.containsKey("Type")) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.TYPE_MISSING, Messages.getMessage("MissingElementTypeErrorMsg", new Object[0]), Severity.ERROR));
        }
        String value = properties.getProperty("Type").trim();
        if (value.isEmpty()) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.EMPTY_TYPE, Messages.getMessage("MissingDestinationType", new Object[0]), Severity.ERROR));
        }
        if (!value.equals(this.validType)) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.TYPE_NOT_VALID, Messages.getMessage("TypeNotValid", this.validType), Severity.ERROR));
        }
        return ViolationSet.emptyViolationSet();
    }
}

