/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.composite;

import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import java.util.Properties;

public abstract class CompositeValidator
extends Validator {
    protected final Validator[] validators;

    protected CompositeValidator(Validator ... validators) {
        this.validators = validators;
    }

    @Override
    protected final ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = null;
        ViolationSet singleViolationSet = null;
        Validator[] validatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator singleValidator = validatorArray[n2];
            singleViolationSet = singleValidator.validate(properties);
            if (singleViolationSet.hasErrors() || singleViolationSet.hasWarnings()) {
                if (violations == null) {
                    violations = new ViolationSet();
                }
                violations.addSet(singleViolationSet);
            }
            ++n2;
        }
        return violations != null ? violations : ViolationSet.emptyViolationSet();
    }
}

