/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.crypto;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Properties;

public class EncryptedDestinationValidator
extends Validator {
    public static final String KEY_LOADING_ERROR = "x-sap-validator-LoadingError";
    public static final String STATUS_KEY_NOT_FOUND = "KeyNotFound";
    public static final String STATUS_KEY_CORRUPTED = "KeyCorrupted";
    public static final String STATUS_PARTIAL_DECRYPTION = "Partial";
    public static final String STATUS_FAILED_DECRYPTION = "Other";

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        String value = properties.getProperty(KEY_LOADING_ERROR);
        if (value != null) {
            if (value.equals(STATUS_KEY_NOT_FOUND)) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.LOAD_FAIL_KEY_NOT_FOUND, Messages.getMessage("OnLoadMissingEncryptionKeyFile", new Object[0]), Severity.ERROR));
            }
            if (value.equals(STATUS_KEY_CORRUPTED)) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.LOAD_FAIL_KEY_CORRUPTED, Messages.getMessage("OnLoadCorruptedEncryptionKeyFile", new Object[0]), Severity.ERROR));
            }
            if (value.equals(STATUS_PARTIAL_DECRYPTION)) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.LOAD_FAIL_PARTIAL, Messages.getMessage("OnLoadDecryptionPartialyFailed", new Object[0]), Severity.ERROR));
            }
            if (value.equals(STATUS_FAILED_DECRYPTION)) {
                return ViolationSet.createViolationSet(new Violation(ViolationType.LOAD_FAIL_FULL, Messages.getMessage("OnLoadDecryptionFailed", new Object[0]), Severity.ERROR));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

