/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.validation.validators.http;

import com.sap.core.connectivity.apiext.validation.i18n.Messages;
import com.sap.core.connectivity.apiext.validation.validators.Validator;
import com.sap.core.connectivity.apiext.validation.violations.Severity;
import com.sap.core.connectivity.apiext.validation.violations.Violation;
import com.sap.core.connectivity.apiext.validation.violations.ViolationSet;
import com.sap.core.connectivity.apiext.validation.violations.ViolationType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class AuthBasicValidator
extends Validator {
    private boolean canBeEmpty;
    private String propertyToCheck;
    private ViolationType propertyMissing;
    private ViolationType propertyNotValid;
    private ViolationType propertyRedundant;
    private static final Set<String> CertificationPropertiesSet = new HashSet<String>(Arrays.asList("KeyStoreLocation", "KeyStorePassword"));

    public AuthBasicValidator(String propertyKey, boolean canBeEmpty, ViolationType propertyMissing, ViolationType propertyNotValid, ViolationType propertyRedundant) {
        this.propertyToCheck = propertyKey;
        this.canBeEmpty = canBeEmpty;
        this.propertyMissing = propertyMissing;
        this.propertyNotValid = propertyNotValid;
        this.propertyRedundant = propertyRedundant;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        boolean authPropertyExists = properties.containsKey(this.propertyToCheck);
        if (!properties.containsKey("Authentication") && authPropertyExists) {
            return ViolationSet.createViolationSet(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "Authentication", this.propertyToCheck), Severity.WARNING));
        }
        if (properties.containsKey("Authentication")) {
            String authentication = properties.getProperty("Authentication").trim();
            if (authentication.equals("BasicAuthentication") && !CertificationPropertiesSet.contains(this.propertyToCheck)) {
                if (!authPropertyExists) {
                    return ViolationSet.createViolationSet(new Violation(this.propertyMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "BasicAuthentication", this.propertyToCheck), Severity.ERROR));
                }
                if (authPropertyExists && !this.canBeEmpty && properties.getProperty(this.propertyToCheck).trim().isEmpty()) {
                    return ViolationSet.createViolationSet(new Violation(this.propertyNotValid, Messages.getMessage("ValueIsEmptyString", this.propertyToCheck), Severity.ERROR));
                }
            } else if (authentication.equals("ClientCertificateAuthentication") && CertificationPropertiesSet.contains(this.propertyToCheck)) {
                if (!authPropertyExists) {
                    return ViolationSet.createViolationSet(new Violation(this.propertyMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "ClientCertificateAuthentication", this.propertyToCheck), Severity.ERROR));
                }
                if (authPropertyExists && !this.canBeEmpty && properties.getProperty(this.propertyToCheck).trim().isEmpty()) {
                    return ViolationSet.createViolationSet(new Violation(this.propertyNotValid, Messages.getMessage("ValueIsEmptyString", this.propertyToCheck), Severity.ERROR));
                }
            }
            if (!authentication.equals("BasicAuthentication") && !authentication.equals("ClientCertificateAuthentication") && authPropertyExists) {
                return ViolationSet.createViolationSet(new Violation(this.propertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", this.propertyToCheck, "Authentication", "BasicAuthentication"), Severity.WARNING));
            }
        }
        return ViolationSet.emptyViolationSet();
    }
}

